% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qform_code.R, R/zzz_niftiImage.R
\docType{methods}
\name{qform_code-methods}
\alias{qform_code-methods}
\alias{qform_code-methods,}
\alias{qform_code}
\alias{qform_code,nifti-method}
\alias{qform_code<-}
\alias{qform_code<-,nifti-method}
\alias{qform.code}
\alias{qform.code,nifti-method}
\alias{qform.code<-}
\alias{qform.code<-,nifti-method}
\alias{qform_code,niftiImage-method}
\alias{qform_code<-,niftiImage-method}
\title{Extract Image Attribute \code{qform_code}}
\usage{
qform_code(object)

\S4method{qform_code}{nifti}(object)

qform_code(object) <- value

\S4method{qform_code}{nifti}(object) <- value

qform.code(object)

\S4method{qform.code}{nifti}(object)

qform.code(object) <- value

\S4method{qform.code}{nifti}(object) <- value

\S4method{qform_code}{niftiImage}(object)

\S4method{qform_code}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{qform_code} field.}
}
\description{
Methods that act on the \code{qform_code} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
qform_code(img)
qform_code(img) = 8
stopifnot(qform_code(img) ==  8)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
