% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthoDr_surv.r
\name{orthoDr_surv}
\alias{orthoDr_surv}
\title{IR-CP model}
\usage{
orthoDr_surv(x, y, censor, ndr = 2, B.initial = NULL, bw = NULL,
  control = list(), maxitr = 500, verbose = FALSE)
}
\arguments{
\item{x}{A matrix or data.frame for features (continous only). The algorithm will not scale the columns to unit variance}

\item{y}{A vector of observed time}

\item{censor}{A vector of censoring indicator}

\item{ndr}{The number of directions}

\item{B.initial}{Initial \code{B} values. Will use the counting process based SIR model \link[orthoDr]{CP_SIR} as the initial if leaving as \code{NULL}.
If specified, must be a matrix with \code{ncol(x)} rows and \code{ndr} columns. Will be processed by Gram-Schmidt if not orthogonal}

\item{bw}{A Kernel bandwith, assuming each variables have unit variance}

\item{control}{A list of tuning varaibles for optimization. \code{epsilon} is the size for numerically appriximating the gradient. For others, see Wen and Yin (2013).}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}
}
\value{
A \code{orthoDr} object; a list consisting of
\item{B}{The optimal \code{B} value}
\item{fn}{The final funtional value}
\item{itr}{The number of iterations}
\item{converge}{convergence code}
}
\description{
The counting process based semiparametric dimention reduction (IR-CP) model for right censored survival outcome.
}
\examples{
# generate some survival data
set.seed(1)
N = 350
P = 6
dataX = matrix(rnorm(N*P), N, P)
failEDR = as.matrix(cbind(c(1, 1, 0, 0, 0, 0, rep(0, P-6)),
                          c(0, 0, 1, -1, 0, 0, rep(0, P-6))))
censorEDR = as.matrix(c(0, 1, 0, 1, 1, 1, rep(0, P-6)))
T = exp(-2.5 + dataX \%*\% failEDR[,1] +
    0.5*(dataX \%*\% failEDR[,1])*(dataX \%*\% failEDR[,2]) + 0.25*log(-log(1-runif(N))))
C = exp( -0.5 + dataX \%*\% censorEDR  + log(-log(1-runif(N))))
Y = pmin(T, C)
Censor = (T < C)

# fit the model
orthoDr.fit = orthoDr_surv(dataX, Y, Censor, ndr = 2)

# compare with the true direction
c(distance(failEDR, orthoDr.fit$B, "dist"),
  distance(failEDR, orthoDr.fit$B, "trace"),
  distance(failEDR, orthoDr.fit$B, "canonical", dataX))
}
\references{
Sun, Q., Zhu, R., Wang T. and Zeng D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
\url{https://arxiv.org/abs/1704.05046} .

Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434.
DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
}
