% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata-class.R, R/osmdata-package.R
\docType{package}
\name{osmdata}
\alias{osmdata}
\title{osmdata class def}
\usage{
osmdata(
  bbox = NULL,
  overpass_call = NULL,
  meta = NULL,
  osm_points = NULL,
  osm_lines = NULL,
  osm_polygons = NULL,
  osm_multilines = NULL,
  osm_multipolygons = NULL
)
}
\arguments{
\item{bbox}{bounding box}

\item{overpass_call}{overpass_call}

\item{meta}{metadata of overpass query, including timestamps and version
numbers}

\item{osm_points}{OSM nodes as \pkg{sf} Simple Features Collection of points
or \pkg{sp} SpatialPointsDataFrame}

\item{osm_lines}{OSM ways \pkg{sf} Simple Features Collection of linestrings
or \pkg{sp} SpatialLinesDataFrame}

\item{osm_polygons}{OSM ways as \pkg{sf} Simple Features Collection of
polygons or \pkg{sp} SpatialPolygonsDataFrame}

\item{osm_multilines}{OSM relations as \pkg{sf} Simple Features Collection
of multilinestrings or \pkg{sp} SpatialLinesDataFrame}

\item{osm_multipolygons}{OSM relations as \pkg{sf} Simple Features
Collection of multipolygons or \pkg{sp}
SpatialPolygonsDataFrame}

\item{...}{other options ignored}
}
\description{
Imports OpenStreetMap (OSM) data into R as either 'sf' or 'sp' objects.  OSM
data are extracted from the overpass API and processed with very fast C++
routines for return to R.  The package enables simple overpass queries to be
constructed without the user necessarily understanding the syntax of the
overpass query language, while retaining the ability to handle arbitrarily
complex queries. Functions are also provided to enable recursive searching
between different kinds of OSM data (for example, to find all lines which
intersect a given point).
}
\note{
Class constructor should never be used directly, and is only exported
to provide access to the print method
}
\section{Functions to Prepare Queries}{

\itemize{
\item \link{getbb}: Get bounding box for a given place name
\item \link{bbox_to_string}: Convert a named matrix or a named vector
(or an unnamed vector) return a string
\item \link{overpass_status}: Retrieve status of the overpass API
\item \link{opq}: Build an overpass query
\item \link{add_osm_feature}: Add a feature to an overpass query
\item \link{opq_string}: Convert an osmdata query to overpass API
string
}
}

\section{Functions to Get Additional OSM Information}{

\itemize{
\item \link{available_features}: List recognised features in OSM
\item \link{available_tags}: List tags associated with a feature
}
}

\section{Functions to Extract OSM Data}{

\itemize{
\item \link{osmdata_sf}: Return OSM data in \pkg{sf} format
\item \link{osmdata_sp}: Return OSM data in \pkg{sp} format
\item \link{osmdata_xml}: Return OSM data in \pkg{XML} format
}
}

\section{Functions to Search Data}{

\itemize{
\item \code{osm_points}: Extract all \code{osm_points} objects
\item \code{osm_lines}: Extract all \code{osm_lines} objects
\item \code{osm_polygons}: Extract all \code{osm_polygons} objects
\item \code{osm_multilines}: Extract all \code{osm_multilines} objects
\item \code{osm_multipolygons}: Extract all \code{osm_multipolygons} objects
}
}

\author{
Mark Padgham, Bob Rudis, Robin Lovelace, Maëlle Salmon
}
