/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;

public class BiomassOutput
extends AbstractOutput {
    private double[] biomass;

    public BiomassOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.biomass = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            if (!this.includeClassZero() && school.getAgeDt() < school.getSpecies().getAgeClassZero()) continue;
            int n = school.getSpeciesIndex();
            this.biomass[n] = this.biomass[n] + school.getInstantaneousBiomass();
        }
    }

    @Override
    public void write(float time) {
        double nsteps = this.getRecordFrequency();
        int i = 0;
        while (i < this.biomass.length) {
            int n = i++;
            this.biomass[n] = this.biomass[n] / nsteps;
        }
        this.writeVariable(time, this.biomass);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_biomass_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder str = new StringBuilder("Mean biomass (tons), ");
        if (this.includeClassZero()) {
            str.append("including ");
        } else {
            str.append("excluding ");
        }
        str.append("first ages specified in input");
        return str.toString();
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

