/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.logging;

import fr.ird.osmose.util.logging.OsmoseLogFormatter;
import fr.ird.osmose.util.logging.SimulationLogFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OLogger {
    private final Logger logger = Logger.getAnonymousLogger();

    public OLogger() {
        this.setupOsmoseLogger();
    }

    public OLogger(int rank) {
        this.setupSimulationLogger(rank);
    }

    private void setupOsmoseLogger() {
        this.logger.setUseParentHandlers(false);
        OsmoseLogFormatter formatter = new OsmoseLogFormatter();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        this.logger.addHandler(handler);
    }

    private void setupSimulationLogger(int rank) {
        Handler[] handlers;
        for (Handler handler : handlers = this.logger.getHandlers()) {
            this.logger.removeHandler(handler);
        }
        this.logger.setUseParentHandlers(false);
        SimulationLogFormatter formatter = new SimulationLogFormatter(rank);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        this.logger.addHandler(handler);
    }

    public void error(String msg, Exception ex) {
        this.logger.log(Level.SEVERE, msg, ex);
        System.exit(1);
    }

    public void warning(String msg) {
        this.logger.warning(msg);
    }

    public void warning(String msg, Object param) {
        this.logger.log(Level.WARNING, msg, param);
    }

    public void warning(String msg, Object[] params) {
        this.logger.log(Level.WARNING, msg, params);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String msg, Object param) {
        this.logger.log(Level.INFO, msg, param);
    }

    public void info(String msg, Object[] params) {
        this.logger.log(Level.INFO, msg, params);
    }

    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    public void debug(String msg, Object param) {
        this.logger.log(Level.FINE, msg, param);
    }

    public void debug(String msg, Object[] params) {
        this.logger.log(Level.FINE, msg, params);
    }
}

