% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-class.R
\name{get_var.osmose}
\alias{get_var.osmose}
\title{get_var method for osmose outputs objects}
\usage{
\method{get_var}{osmose}(object, what, how = c("matrix", "list"), expected = FALSE, ...)
}
\arguments{
\item{object}{Object of \code{osmose} class (see the \code{\link{read_osmose}} 
function).}

\item{what}{Name of variable to extract. See Details.}

\item{how}{How to return the object. Current options are "matrix" and "list".}

\item{expected}{A logical parameter. If \code{TRUE}, the average over the 
last dimensions will be performed (only if the output is an array).}

\item{...}{Additional arguments of the function.}
}
\value{
An matrix or a list containing the data.
}
\description{
Get a variable from an \code{osmose} object.
}
\details{
\code{what} can be any available variable contained on \code{object}
(e.g. biomass, abundance, yield, yieldN, etc).
}
