% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoder.R
\name{decode_geom}
\alias{decode_geom}
\title{Transform encoded polylines to lat-lng data.frame.}
\usage{
decode_geom(encoded, precision = stop("a numeric, either 5 or 6"))
}
\arguments{
\item{encoded}{A character containing encoded polylines}

\item{precision}{A numeric (either 5 or 6) to specify the precision of [lat,lng] encoding.
(OSRM API v4 used precision 5 with "polyline", OSRM API v5 uses precision 6 with "polyline6")}
}
\value{
data.frame with lat and lng
}
\description{
decode_geom() uses a decoding algorithm to decode polylines. (http://stackoverflow.com/questions/32476218/how-
to-decode-encoded-polylines-from-osrm-and-plotting-route-geometry)
}
\examples{
decoded_api_4 <- decode_geom(osrmr::encoded_string_api_4, precision = 5)
decoded_api_5 <- decode_geom(osrmr::encoded_string_api_5, precision = 6)
decoded_api_4[1:3,]
#        lat     lng
# 1 47.10020 8.09970
# 2 47.09850 8.09207
# 3 47.09617 8.09118
decoded_api_5[1:3,]
#        lat      lng
# 1 47.10020 8.099703
# 2 47.09850 8.092074
# 3 47.09617 8.091181
assertthat::assert_that(all.equal(decoded_api_4, decoded_api_5, tolerance = 1e-6))
}
