% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genetic.optim.IWKMEIV.R
\name{Genetic.optim.IWKMEIV}
\alias{Genetic.optim.IWKMEIV}
\title{The optimal treatment regime based on the (S)IWKMEIV estimator.}
\usage{
Genetic.optim.IWKMEIV(datalist, ps, t0, smooth = TRUE)
}
\arguments{
\item{datalist}{A list used to calculate the (S)IWKMEIV estimator including instrument named z, treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}. Notice that all the data in the datalist should be ordered by observed time.}

\item{ps}{A list including the probability of receiving instrument given baseline covariates named \code{fzl} and the difference between fal1 and fal0 named \code{deltal}, where fal0 denotes the probability of receiving treatment given baseline covariates and instrument equaling 0, and fal1 denotes the probability of receiving treatment given baseline covariates and instrument equaling 1. \code{\link[otrKM]{Fps.IWKMEIV}} can produce \code{ps} by positing logistic model.}

\item{t0}{A predetermined time.}

\item{smooth}{A logic variable indicating wether a smoothed version should be used.}
}
\value{
A numeric vector in which the last number is the estimated optimal t0-year survival probability and others are the estimated parameter of the optimal treatment regime.
}
\description{
Given a predetermined t0, estimate the optimal treatment regime by maximizing t0-year survival probability based on the (S)IWKMEIV estimator.
}
\details{
More details can be found in references.
}
\examples{
# load data
data(simulation)
simulation=simulation[order(simulation$Survival),]

# convert the data into a datalist
datalist=list(z=simulation$Instrument,a=simulation$Treatment,
              obs.t=simulation$Survival,delta=simulation$Status,
              l=cbind(simulation$Covariate1,simulation$Covariate2))

# predetermined t0
t0=1

# calculate ps and prep
ps=Fps.IWKMEIV(datalist, t0)

Genetic.optim.IWKMEIV(datalist, ps, t0, smooth=TRUE)
}
\references{
{Xia, J., Zhan, Z., Zhang, J. (2022) An anti-confounding method for estimating optimal regime in a survival context using instrumental variable. Under Review.}
}
