% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{valid_syntax}
\alias{valid_syntax}
\title{Check whether a string is valid R code}
\usage{
valid_syntax(script)
}
\arguments{
\item{script}{The code snippet}
}
\value{
Whether the code snippet is valid (can be parsed with \code{parse})
}
\description{
Determine whether a code snippet has any syntax errors.
}
\examples{
s = "
a = TRUE
b = c(1, 2, 3)
d = function(x) x ^ 2
f = d(b)
"
valid_syntax(s)
#> [1] TRUE

s = "
if (TRUE) {
  a = c(1, 2)
"
valid_syntax(s)
#> [1] FALSE
}
