% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_print.R
\name{PlotVar}
\alias{PlotVar}
\title{Create over time variable plots and summary statitsics for one variable}
\usage{
PlotVar(dataFl, myVar, weightNm, dateNm, dateGp, dateGpBp = NULL,
  labelFl = NULL, highlightNms = NULL, skewOpt = NULL, kSample = 50000,
  fuzzyLabelFn = NULL, kCategories = 9)
}
\arguments{
\item{dataFl}{A \code{data.table} containing at least the following columns:
\code{myVar}, \code{weightNm}, \code{dateGp}, \code{dateGpBp}; usually an
output of the \code{\link{PrepData}} function.}

\item{myVar}{Name of the variable to be plotted.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}

\item{dateNm}{Name of column containing the date variable.}

\item{dateGp}{Name of the variable that the time series plots should be 
grouped by. Options are \code{NULL}, \code{"weeks"}, \code{"months"}, 
\code{"quarters"}, \code{"years"}. See \code{\link[data.table]{IDate}} for
details. If \code{NULL}, then \code{dateNm} will be used as \code{dateGp}.}

\item{dateGpBp}{Name of variable the boxplots should be grouped by. Same
options as \code{dateGp}. If \code{NULL}, then \code{dateGp} will be used.}

\item{labelFl}{A \code{data.table} containing variable labels, or \code{NULL}
for no labels; usually an output of \code{\link{PrepLabels}}.}

\item{highlightNms}{Either \code{NULL} or a character vector of variables to
recieve red label. Currently \code{NULL} means all variables will get a 
black legend. Ignored this argument if \code{labelFl == NULL}.}

\item{skewOpt}{Either a numeric constant or \code{NULL}. Default is 
\code{NULL} (no transformation). If numeric, say 5, then all box plots of
a variable whose skewness exceeds 5 will be on a log10 scale if possible.
Negative input of \code{skewOpt} will be converted to 3.}

\item{kSample}{Either \code{NULL} or a positive integer. If an integer, 
indicates the sample size for both drawing boxplots and ordering numerical
graphs by \eqn{R^2}. When the data is large, setting \code{kSample} to a 
reasonable value (default is 50K) dramatically improves processing speed. 
Therefore, for larger datasets (e.g. > 10 percent system memory), this
parameter should not be set to \code{NULL}, or boxplots may take a very
long time to render. This setting has no impact on the accuracy of time 
series plots on quantiles, mean, SD, and missing and zero rates.}

\item{fuzzyLabelFn}{Either \code{NULL} or a function of 2 parameters: A label
file in the format of an output by \code{\link{PrepLabels}} and a string
giving a variable name. The function should return the label corresponding
to the variable given by the second parameter. This function should 
describe how fuzzy matching should be performed to find labels (see example
below). If \code{NULL}, only exact matches will be retuned.}

\item{kCategories}{If a categorical variable has more than \code{kCategories},
trace plots of only the \code{kCategories} most prevalent categories are
plotted.}
}
\value{
\item{p}{A \code{grob} (i.e., \code{ggplot} grid) object. See the output
    \code{p} of the function or \code{\link{PlotNumVar}}
    \code{\link{PlotCatVar}} for details.}
  \item{varSummary}{A \code{data.table} of summary statistics. See the output
    \code{numVarSummary} of the function \code{\link{PlotNumVar}}, or the 
    output \code{catVarSummary} of the function \code{\link{PlotCatVar}} for 
    details.}
  \item{varType}{Indicator of the variable's type, either \code{"nmrcl"} or 
    \code{"ctgrl"}.}
}
\description{
For a numerical variable, the output includes 
\itemize{
\item side-by-side boxplots grouped by \code{dateGpBp} (left), 
\item a trace plot of p1, p50, and p99 percentiles, grouped by \code{dateGp}
  (top right), 
\item a trace plot of mean and +-1 SD control limits, grouped by 
  \code{dateGp}(middle right), and 
\item a trace plot of missing and zerorates, grouped by \code{dateGp} 
  (bottom right).
}
For a categorical variable (including a numerical variable with no more than 2
unique levels not including NA), the output includes 
\itemize{
\item a frequency bar plot (left), and 
\item a grid of trace plots on categories' proportions over time (right). 
If the variable contains more than \code{kCategories} number of categories, 
trace plots of only the largest \code{kCategories} will be plotted. 
}
In addition to plots, a \code{data.table} of summary statistics are generated,
on global and over time summary statistics.
}
\section{License}{
 Copyright 2017 Capital One Services, LLC Licensed under the
Apache License, Version 2.0 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of the  License
at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
law or agreed to in writing, software distributed under the License is
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied. See the License for the specific language
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "months", 
                     dateGpBp = "quarters")
data(bankLabels)
bankLabels <- PrepLabels(bankLabels)

## PlotVar will treat numerical and categorical data differently. 
## Binary data is always treated as categorical.
plot(PlotVar(bankData, myVar = "duration", weightNm = NULL, dateNm = "date", 
     dateGp = "months", dateGpBp =  "quarters", labelFl = bankLabels)$p)
plot(PlotVar(bankData, myVar = "job", weightNm = NULL, dateNm = "date", 
     dateGp = "months", dateGpBp =  "quarters", labelFl = bankLabels)$p)
plot(PlotVar(bankData, myVar = "loan", weightNm = NULL, dateNm = "date", 
     dateGp = "months", dateGpBp =  "quarters", labelFl = bankLabels)$p)

}
\seealso{
Functions depend on this function:
         \code{\link{PrintPlots}}.

This function depends on:
         \code{\link{PlotCatVar}},
         \code{\link{PlotNumVar}},
         \code{\link{PrepData}}.
}
