% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{module_install}
\alias{module_install}
\title{Install an outsider module}
\usage{
module_install(
  repo = NULL,
  url = NULL,
  filepath = NULL,
  git = NULL,
  service = c("github", "bitbucket", "gitlab"),
  tag = "latest",
  manual = FALSE,
  verbose = FALSE,
  force = FALSE,
  update = c("default", "ask", "always", "never")
)
}
\arguments{
\item{repo}{Module repo, character.}

\item{url}{URL to downloadable compressed (zip, tar or bzipped/gzipped)
folder of a module, character.}

\item{filepath}{Filepath to uncompressed directory of module, character.}

\item{git}{URL to git repository}

\item{service}{Code-sharing service. Character.}

\item{tag}{Module version, default latest. Character.}

\item{manual}{Build the docker image? Default FALSE. Logical.}

\item{verbose}{Be verbose? Default FALSE.}

\item{force}{Ignore warnings and install anyway? Default FALSE.}

\item{update}{Update dependent R packages?}
}
\value{
Logical
}
\description{
Install a module through multiple different methods: via a code
sharing site such as GitHub, a URL, a git repository or local filepath.
The function will first install the R package and then build the Docker
image. Docker image version is determined by "tag". To avoid pulling
the image from DockerHub set "manual" to TRUE.
}
\details{
All installation options depend on the installation functions of
\code{remotes}. E.g. GitHub packages are installed with
\code{\link[remotes]{install_github}}. See these functions for more details
on the R package installation process.
}
\examples{
library(outsider)
# NOT RUN (too slow for automated testing)
\dontrun{
  if (is_outsider_ready()) {
    # simplest repo
    repo <- 'dombennett/om..hello.world'
    # install
    module_install(repo = repo, force = TRUE, update = 'never')
    # is module_installed?
    (is_module_installed(repo = repo))
    # uninstall
    module_uninstall(repo)
  }
}
}
\seealso{
Other public: 
\code{\link{is_module_installed}()},
\code{\link{module_details}()},
\code{\link{module_functions}()},
\code{\link{module_help}()},
\code{\link{module_import}()},
\code{\link{module_installed}()},
\code{\link{module_search}()},
\code{\link{module_uninstall}()}
}
\concept{public}
