% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_render.R
\name{owid_output}
\alias{owid_output}
\alias{owid_server}
\title{Create OWID chart output elements in Shiny}
\usage{
owid_output(id)

owid_server(id, url, width = "100\%", height = "600px")
}
\arguments{
\item{id}{Character string. The ID of the output element.}

\item{url}{Character string. The URL of the OWID chart to embed.}

\item{width}{Character string. The width of the chart (default: "100\%").}

\item{height}{Character string. The height of the chart (default: "600px").}
}
\value{
A Shiny HTML output element where the OWID chart will be rendered.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function creates an HTML output element for embedding Our World in Data
(OWID) charts in a Shiny application. It should be used in the UI definition
of your Shiny app.
}
\examples{
\dontshow{if (interactive() & curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)

ui <- fluidPage(
 owid_output("gdp_chart"),
 owid_output("co2_chart")
)

server <- function(input, output) {
 owid_server(
   "gdp_chart",
   "https://ourworldindata.org/grapher/gdp-per-capita-worldbank?tab=line"
 )
 owid_server(
   "co2_chart",
   "https://ourworldindata.org/grapher/co2-emissions-per-capita",
   height = "500px"
 )
}

shinyApp(ui = ui, server = server)
\dontshow{\}) # examplesIf}
}
