% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_search.R
\name{owid_search}
\alias{owid_search}
\title{Search for keywords in OWID catalog data}
\usage{
owid_search(data, keywords, columns = NULL)
}
\arguments{
\item{data}{A data frame, typically obtained from \link{owid_get_catalog}.}

\item{keywords}{A character vector of one or more keywords to search for.
The search is case-insensitive.}

\item{columns}{An optional character vector of column names to search within.
If NULL (default), all character and factor columns are searched.}
}
\value{
A filtered data frame containing only rows that match at least one of
the keywords in at least one of the specified columns.
}
\description{
This function searches for a vector of keywords within specified columns of
an OWID catalog data frame. If no columns are specified, it
searches all character and factor columns.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get the OWID catalog
catalog <- owid_get_catalog()

# Search for climate or carbon in all text columns
owid_search(catalog, c("climate", "carbon"))

# Search only in the title column
owid_search(catalog, c("climate", "carbon"), c("title"))
}
\dontshow{\}) # examplesIf}
}
