% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCSClient.R
\docType{class}
\name{WCSClient}
\alias{WCSClient}
\title{WCSClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Coverage Service.
}
\description{
WCSClient

WCSClient
}
\examples{
\dontrun{
   wcs <- WCSClient$new("http://localhost:8080/geoserver/wcs", serviceVersion = "2.0.1")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Coverage}
\keyword{OGC}
\keyword{WCS}
\section{Super classes}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{\link[ows4R:OWSClient]{ows4R::OWSClient}} -> \code{WCSClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WCSClient-new}{\code{WCSClient$new()}}
\item \href{#method-WCSClient-getCapabilities}{\code{WCSClient$getCapabilities()}}
\item \href{#method-WCSClient-reloadCapabilities}{\code{WCSClient$reloadCapabilities()}}
\item \href{#method-WCSClient-describeCoverage}{\code{WCSClient$describeCoverage()}}
\item \href{#method-WCSClient-getCoverage}{\code{WCSClient$getCoverage()}}
\item \href{#method-WCSClient-clone}{\code{WCSClient$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getCASUrl"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getCASUrl'><code>ows4R::OWSClient$getCASUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getConfig"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getConfig'><code>ows4R::OWSClient$getConfig()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getHeaders"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getHeaders'><code>ows4R::OWSClient$getHeaders()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getPwd"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getPwd'><code>ows4R::OWSClient$getPwd()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getToken"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getToken'><code>ows4R::OWSClient$getToken()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getUrl"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getUrl'><code>ows4R::OWSClient$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getUser"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getUser'><code>ows4R::OWSClient$getUser()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSClient" data-id="getVersion"><a href='../../ows4R/html/OWSClient.html#method-OWSClient-getVersion'><code>ows4R::OWSClient$getVersion()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate a \link{WCSClient} with the \code{url} of the
   OGC service. Authentication is supported using basic auth (using \code{user}/\code{pwd} arguments), 
   bearer token (using \code{token} argument), or custom (using \code{headers} argument). By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$new(
  url,
  serviceVersion = NULL,
  user = NULL,
  pwd = NULL,
  token = NULL,
  headers = c(),
  config = httr::config(),
  cas_url = NULL,
  logger = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{serviceVersion}}{WFS service version}

\item{\code{user}}{user}

\item{\code{pwd}}{password}

\item{\code{token}}{token}

\item{\code{headers}}{headers}

\item{\code{config}}{config}

\item{\code{cas_url}}{Central Authentication Service (CAS) URL}

\item{\code{logger}}{logger}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-getCapabilities"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-getCapabilities}{}}}
\subsection{Method \code{getCapabilities()}}{
Get WCS capabilities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$getCapabilities()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \link{WCSCapabilities}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-reloadCapabilities"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-reloadCapabilities}{}}}
\subsection{Method \code{reloadCapabilities()}}{
Reloads WCS capabilities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$reloadCapabilities()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-describeCoverage"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-describeCoverage}{}}}
\subsection{Method \code{describeCoverage()}}{
Describes coverage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$describeCoverage(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{WCSCoverageDescription}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-getCoverage"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-getCoverage}{}}}
\subsection{Method \code{getCoverage()}}{
Get coverage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$getCoverage(
  identifier,
  bbox = NULL,
  crs = NULL,
  time = NULL,
  format = NULL,
  rangesubset = NULL,
  gridbaseCRS = NULL,
  gridtype = NULL,
  gridCS = NULL,
  gridorigin = NULL,
  gridoffsets = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}

\item{\code{bbox}}{bbox. Default is \code{NULL}}

\item{\code{crs}}{crs. Default is \code{NULL}}

\item{\code{time}}{time. Default is \code{NULL}}

\item{\code{format}}{format. Default is "image/tiff"}

\item{\code{rangesubset}}{rangesubset. Default is \code{NULL}}

\item{\code{gridbaseCRS}}{grid base CRS. Default is \code{NULL}}

\item{\code{gridtype}}{grid type. Default is \code{NULL}}

\item{\code{gridCS}}{grid CS. Default is \code{NULL}}

\item{\code{gridorigin}}{grid origin. Default is \code{NULL}}

\item{\code{gridoffsets}}{grid offsets. Default is \code{NULL}}

\item{\code{...}}{any other argument to pass to the WCS GetCoverage request}

\item{\code{elevation}}{elevation. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{SpatRaster} from \pkg{terra}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WCSClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
