% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCSCoverageSummary.R
\docType{class}
\name{WCSCoverageSummary}
\alias{WCSCoverageSummary}
\title{WCSCoverageSummary}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} modelling a WCS coverage summary
}
\description{
WCSCoverageSummary

WCSCoverageSummary
}
\note{
Class used internally by ows4R.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Coverage}
\keyword{OGC}
\keyword{WCS}
\section{Super class}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{WCSCoverageSummary}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{CoverageId}}{coverage id}

\item{\code{CoverageSubtype}}{coverage subtype}

\item{\code{CoverageSubtypeParent}}{coverage subtype parent}

\item{\code{WGS84BoundingBox}}{WGS84 bounding box}

\item{\code{BoundingBox}}{bounding box}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WCSCoverageSummary-new}{\code{WCSCoverageSummary$new()}}
\item \href{#method-WCSCoverageSummary-getId}{\code{WCSCoverageSummary$getId()}}
\item \href{#method-WCSCoverageSummary-getSubtype}{\code{WCSCoverageSummary$getSubtype()}}
\item \href{#method-WCSCoverageSummary-getSubtypeParent}{\code{WCSCoverageSummary$getSubtypeParent()}}
\item \href{#method-WCSCoverageSummary-getWGS84BoundingBox}{\code{WCSCoverageSummary$getWGS84BoundingBox()}}
\item \href{#method-WCSCoverageSummary-getBoundingBox}{\code{WCSCoverageSummary$getBoundingBox()}}
\item \href{#method-WCSCoverageSummary-getDescription}{\code{WCSCoverageSummary$getDescription()}}
\item \href{#method-WCSCoverageSummary-getDimensions}{\code{WCSCoverageSummary$getDimensions()}}
\item \href{#method-WCSCoverageSummary-getCoverage}{\code{WCSCoverageSummary$getCoverage()}}
\item \href{#method-WCSCoverageSummary-getCoverageStack}{\code{WCSCoverageSummary$getCoverageStack()}}
\item \href{#method-WCSCoverageSummary-clone}{\code{WCSCoverageSummary$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-new"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{WCSCoverageSummary} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$new(
  xmlObj,
  capabilities,
  serviceVersion,
  owsVersion,
  logger = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xmlObj}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{capabilities}}{object of class \link{WCSCapabilities}}

\item{\code{serviceVersion}}{WCS service version}

\item{\code{owsVersion}}{version}

\item{\code{logger}}{logger type \code{NULL}, "INFO" or "DEBUG"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getId"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getId}{}}}
\subsection{Method \code{getId()}}{
Get coverage ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getSubtype"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getSubtype}{}}}
\subsection{Method \code{getSubtype()}}{
Get sub type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getSubtype()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getSubtypeParent"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getSubtypeParent}{}}}
\subsection{Method \code{getSubtypeParent()}}{
Get sub type parent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getSubtypeParent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getWGS84BoundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getWGS84BoundingBox}{}}}
\subsection{Method \code{getWGS84BoundingBox()}}{
Get bounding box
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getWGS84BoundingBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \link{OWSWGS84BoundingBox}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getBoundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getBoundingBox}{}}}
\subsection{Method \code{getBoundingBox()}}{
Get WGS84 bounding box
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getBoundingBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \link{OWSBoundingBox}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getDescription"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getDescription}{}}}
\subsection{Method \code{getDescription()}}{
Get description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getDescription()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \link{WCSCoverageDescription}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getDimensions"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getDimensions}{}}}
\subsection{Method \code{getDimensions()}}{
Get dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getDimensions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the list of dimensions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getCoverage"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getCoverage}{}}}
\subsection{Method \code{getCoverage()}}{
Get coverage data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getCoverage(
  bbox = NULL,
  crs = NULL,
  time = NULL,
  elevation = NULL,
  format = NULL,
  rangesubset = NULL,
  gridbaseCRS = NULL,
  gridtype = NULL,
  gridCS = NULL,
  gridorigin = NULL,
  gridoffsets = NULL,
  method = "GET",
  filename = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{bbox. Default is \code{NULL}}

\item{\code{crs}}{crs. Default is \code{NULL}}

\item{\code{time}}{time. Default is \code{NULL}}

\item{\code{elevation}}{elevation. Default is \code{NULL}}

\item{\code{format}}{format. Default will be GeoTIFF, coded differently depending on the WCS version.}

\item{\code{rangesubset}}{rangesubset. Default is \code{NULL}}

\item{\code{gridbaseCRS}}{grid base CRS. Default is \code{NULL}}

\item{\code{gridtype}}{grid type. Default is \code{NULL}}

\item{\code{gridCS}}{grid CS. Default is \code{NULL}}

\item{\code{gridorigin}}{grid origin. Default is \code{NULL}}

\item{\code{gridoffsets}}{grid offsets. Default is \code{NULL}}

\item{\code{method}}{method to get coverage, either 'GET' or 'POST' (experimental - under development)}

\item{\code{filename}}{filename. Optional filename to download the coverage}

\item{\code{...}}{any other argument to \link{WCSGetCoverage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{SpatRaster} from \pkg{terra}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-getCoverageStack"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-getCoverageStack}{}}}
\subsection{Method \code{getCoverageStack()}}{
Get a spatio-temporal coverage data cubes as coverage \link{stack}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$getCoverageStack(
  time = NULL,
  elevation = NULL,
  bbox = NULL,
  filename_handler = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{time}

\item{\code{elevation}}{elevation}

\item{\code{bbox}}{bbox}

\item{\code{filename_handler}}{Optional filename handling function with arguments 'identifier', 'time', 'elevation', 'bbox', 'format'
See \link{WCSCoverageFilenameHandler} as genric filename handler that can be used.}

\item{\code{...}}{any other parameter to pass to \code{getCoverage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{stack} from \pkg{raster}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSummary-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSummary-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSummary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
