% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdaOpt.R
\name{lambdaOpt}
\alias{lambdaOpt}
\title{Lambda calibration}
\usage{
lambdaOpt(pvalues, family, alpha = 0.05, delta = 0, step.down = FALSE,
 max.step = 10, m = NULL)
}
\arguments{
\item{pvalues}{matrix of pvalues with dimensions \eqn{m \times B} used instead of the data matrix \code{X}. Default to @NULL.}

\item{family}{string character. Choose a family of confidence envelopes to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"} and \code{"higher.criticism"}.}

\item{alpha}{numeric value in `[0,1]`. It expresses the alpha level to control the family-wise error rate. Default 0.05.}

\item{delta}{numeric value. It expresses the delta value, please see the references. Default to 0.}

\item{step.down}{Boolean value. Default @FALSE If you want to compute the lambda calibration parameter using the step-down approach put \code{TRUE}.}

\item{max.step}{Numeric value. Default to 10. Maximum number of steps for the step down approach, so useful when \code{step.down = TRUE}.}

\item{m}{numeric value. Number of hypothesis. Default @NULL.}
}
\value{
numeric value. It expresses the lambda parameter estimate, please see package references.
}
\description{
\code{lambdaOpt} computes the optimal lambda calibration parameter used in the critical vector.
}
\examples{
db <- simulateData(pi0 = 0.8, m = 100, n = 20, rho = 0)
out <- signTest(X = db)
pv <- cbind(out$pv, out$pv_H0)
cv <- lambdaOpt(pvalues = pv, family = "simes", alpha = 0.05)
}
\author{
Angela Andreella
}
