#' Precipitation summary plot
#'
#' Function for plotting precipitation summary (line, matrix, box, and density)
#'
#' @import ggplot2
#' @importFrom ggpubr ggarrange
#' @param x a csv generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_summary <- function(x){
  p01 <- plot_line(x)
  p02 <- plot_heatmap(x)
  p03 <- plot_box(x)
  p04 <- plot_density(x)
  p05 <- ggarrange(p01, p02, ncol = 1)
  p06 <- ggarrange(p03, p04, ncol = 2)
  p00 <- ggarrange(p05, p06, ncol = 1, heights = c(2, 1))
  return(p00)
}

