#' Precipitation taylor diagram
#'
#' Function for plotting (taylor diagram) time-series of area averaged precipitation
#'
#' @import data.table
#' @importFrom openair TaylorDiagram
#' @importFrom scales hue_pal
#' @param data a csv generated by \code{\link{make_ts}}
#' @param ref a csv to be used as reference in the same format as that generated by \code{\link{make_ts}}. I.e., with columns: "date", "value", "name", and "type".
#' @param groups a string character to define panels. Suitable options are:
#' \itemize{
#' \item "type" (default)
#' \item "seasons" (only works properly with monthly data)
#' }
#' @param ... extra arguments for plot aesthetics
#' @return plot object
#' @export

plot_taylor <- function(data, ref, groups = "type", ...){
  text_obs <- ref$name[1]
  ref <- ref[, .(obs = value), .(date)]
  precip <- merge(ref, data, by = "date")
  precip[month(date) == 1 | month(date) == 2 | month(date) == 12,
         seasons := "Winter DJF"
         ][month(date) == 3 | month(date) == 4 | month(date) == 5, 
           seasons := "Spring MAM"
           ][month(date) == 6 | month(date) == 7 | month(date) == 8,
             seasons := "Summer JJA"
             ][month(date) == 9 | month(date) == 10 | month(date) == 11,
               seasons := "Fall SON"]
  precip$seasons <- factor(precip$seasons, levels = c("Spring MAM",
                                                      "Summer JJA",
                                                      "Fall SON",
                                                      "Winter DJF"))
  p00 <- TaylorDiagram(precip, obs = "obs", mod = "value", group = "name", 
                       type = groups, xlab = NULL, annotate = "CRMSE",
                       normalise = TRUE, auto.text = FALSE,
                       ylab = "Standard Deviation (Normalized)",
                       key.title = "Data Set",
                       text.obs = text_obs, ...)
  return(p00)
}