% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_model_functions.R
\name{checks_markov_pick_method}
\alias{checks_markov_pick_method}
\title{Checks the input to run the Markov cycles and picks correct method}
\usage{
checks_markov_pick_method(
  current_strategy,
  initial_state,
  discount,
  method,
  half_cycle_correction,
  startup_cost,
  startup_util,
  state_cost_only_prevalent,
  state_util_only_prevalent
)
}
\arguments{
\item{current_strategy}{strategy object}

\item{initial_state}{value of states initially}

\item{discount}{rate of discount for costs and qalys}

\item{method}{what type of half cycle correction needed}

\item{half_cycle_correction}{boolean to indicate half cycle correction}

\item{startup_cost}{cost of states initially}

\item{startup_util}{utility of states initially if any}

\item{state_cost_only_prevalent}{boolean parameter to indicate
if the costs for state occupancy is only for those in the state excluding
those that transitioned new. This is relevant when the transition cost
is provided for eg. in a state with dialysis the cost of previous dialysis
is different from the newly dialysis cases.Then the
state_cost_only_prevalent should be TRUE}

\item{state_util_only_prevalent}{boolean parameter to indicate if the
utilities for state occupancy is only for those in the state excluding
those that transitioned new.}
}
\value{
changed method name
}
\description{
Checks the input to run the Markov cycles and picks correct method
}
\examples{
\donttest{
tmat <- rbind(c(1, 2), c(3, 4))
colnames(tmat) <- rownames(tmat) <- c("Healthy", "Dead")
tm <- populate_transition_matrix(2, tmat, c(0.5, 0.5, 0, 1))
a <- health_state("Healthy", 1, 1, 0, FALSE)
b <- health_state("Dead", 1, 0, 0, TRUE)
health_states <- combine_state(a, b)
this.strategy <- strategy(tm, health_states, "intervention")
checks_markov_pick_method(this.strategy, c(1, 0), c(0, 0),
"half cycle correction", TRUE,NULL,NULL)
}
}
