% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{set_desc_url}
\alias{set_desc_url}
\title{Set a \file{DESCRIPTION} File's \acronym{URL} Field}
\usage{
set_desc_url(
  url,
  path = ".",
  normalize = TRUE,
  overwrite = FALSE,
  do_commit = is_force(),
  do_remind = !isTRUE(getOption("packager")[["force"]]),
  verbose = getOption("packager")[["verbose"]]
)
}
\arguments{
\item{url}{A character string giving the \acronym{URL} to set or add in
\file{DESCRIPTION}.}

\item{path}{Path to the \file{DESCRIPTION} file, see
\code{\link[desc:desc_get_urls]{desc::desc_get_urls}}.}

\item{normalize}{See \code{\link[desc:desc_set_urls]{desc::desc_set_urls}}.}

\item{overwrite}{Set (overwrite) the \acronym{URL} field in
\file{DESCRIPTION}
instead
adding the \acronym{URL} given to the \acronym{URL} field in
\file{DESCRIPTION}?}

\item{do_commit}{Commit the updated \file{DESCRIPTION}?}

\item{do_remind}{Write a reminder into the package's \file{TODO.md}?}

\item{verbose}{Be verbose?}
}
\value{
\code{\link[=invisible]{Invisibly} \link[=logical]{TRUE}}
}
\description{
I frequently forget to add an \acronym{URL} to my packages'
\file{DESCRIPTION} files,
and when I do not, I often forget to check that the \acronym{URL} is valid,
respectively the one I want. \cr
So this is a wrapper to functions from \pkg{desc} and \pkg{git2r} and i
messaging and/or adding
a reminder to file \code{TODO.md}.
}
\examples{
path <- file.path(tempdir(), "myPackage")
unlink(path, recursive = TRUE)
usethis::create_package(path, open = FALSE)
repo <- git2r::init(path)
git2r::config(repo, user.name = "foobar", user.email = "foobar@nowhe.re")
git2r::add(repo = repo, path = "*")
git2r::commit(repo = repo, message = "Initial commit")
url <- provide_gitlab_url(path = path)
set_desc_url(url, path = path)
git2r::commits(repo)
git2r::status(repo)
readLines(file.path(path, "TODO.md"))
}
\keyword{internal}
