% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namespace.R
\name{pac_namespace}
\alias{pac_namespace}
\title{package NAMESPACE file}
\usage{
pac_namespace(
  pac,
  version = NULL,
  at = NULL,
  local = FALSE,
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{at}{\code{Date} from which to take the version. Default: \code{NULL}}

\item{local}{\code{logical} if to use local repository (or newest remote packages). Default: \code{FALSE}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector repositories URLs to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
\code{list} with names proper for NAMESPACE file, the same as format as returned by \code{base::parseNamespaceFile}.
}
\description{
CRAN package NAMESPACE file taken locally or remotely from GITHUB CRAN mirror or CRAN website.
By default works for the newest package version.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
This function is mainly built under source code from \code{base::parseNamespaceFile}.
}
\examples{
\dontrun{
pacs::pac_namespace("dplyr", version = "0.8.0")
pacs::pac_namespace("dplyr", at = as.Date("2019-02-01"))
pacs::pac_namespace("memoise", local = TRUE)
}
}
