% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataspace.R
\name{pa_browse_dataspace}
\alias{pa_browse_dataspace}
\title{Browse satellite products from the Copernicus Data
  Space Ecosystem}
\usage{
pa_browse_dataspace(
  aoi,
  start.date,
  end.date,
  max.cloud.cover = 100,
  collection.name = c("SENTINEL-2"),
  product.name = c("MSIL2A"),
  max.results = 1000
)
}
\arguments{
\item{aoi}{sf object used to filter satellite products}

\item{start.date}{beginning of the time window to filter
satellite products. The date format should be `\%Y-\%m-\%d`.}

\item{end.date}{end of the time window to filter
satellite products. The date format should be `\%Y-\%m-\%d`.}

\item{max.cloud.cover}{maximum cloud cover. Values should
be between 0 and 100. Images with cloud cover
assessment greater than this parameter will be removed
from the list.}

\item{collection.name}{collection of products to filter.
Currently, only SENTINEL-2 is supported.}

\item{product.name}{partial match of product name used to
filter products. Currently, only supports MSIL2A.
We plan to expand this in the future.}

\item{max.results}{maximum number of results to return}
}
\value{
a list of entries
  available for download
}
\description{
Browse satellite products from the
  Copernicus Data Space Ecosystem
}
\details{
`pa_browse_dataspace()` will use HTTP requests to
  communicate with the Data Space API and search for
  available satellite products matching the filters
  established by the function parameters.
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "pacu")
area.of.interest <- sf::st_read(file.path(extd.dir, 'cobs_a_aoi.shp'), quiet = TRUE)
available.images <- pa_browse_dataspace(aoi = area.of.interest,
                                        max.cloud.cover = 10,
                                        start.date = '2023-01-01',
                                        end.date = '2023-12-31')
}

}
\author{
Caio dos Santos and Fernando Miguez
}
