% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R
\name{repo_add}
\alias{repo_add}
\alias{repo_resolve}
\title{Add a new CRAN-like repository}
\usage{
repo_add(..., .list = NULL)

repo_resolve(spec)
}
\arguments{
\item{...}{Repository specifications, possibly named character vectors.
See details below.}

\item{.list}{List or character vector of repository specifications.
This argument is easier to use programmatically than \code{...}. See
details below.}

\item{spec}{Repository specification, a possibly named character
scalar.}
}
\value{
\code{repo_resolve()} returns a named character scalar, the URL
of the repository.
}
\description{
Add a new repository to the list of repositories that pak uses to
look for packages.
}
\details{
\code{repo_add()} adds new repositories. It resolves the specified
repositories using \code{repo_resolve()} and then modifies the \code{repos}
global option.

\code{repo_add()} only has an effect in the current R session. If you
want to keep your configuration between R sessions, then set the
\code{repos} option to the desired value in your user or project \code{.Rprofile}
file.
}
\section{Repository specifications}{
The format of a repository specification is a named or unnamed
character scalar. If the name is missing, pak adds a name
automatically. The repository named \code{CRAN} is the main CRAN repository,
but otherwise names are informational.

Currently supported repository specifications:
\itemize{
\item URL pointing to the root of the CRAN-like repository. Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{https://cloud.r-project.org
}\if{html}{\out{</div>}}
\item \verb{RSPM@<date>}, RSPM (RStudio Package Manager) snapshot, at the
specified date.
\item \verb{RSPM@<package>-<version>} RSPM snapshot, for the day after the
release of \verb{<version>} of \verb{<package>}.
\item \verb{RSPM@R-<version>} RSPM snapshot, for the day after R \verb{<version>}
was released.
\item \verb{MRAN@<date>}, MRAN (Microsoft R Application Network) snapshot, at
the specified date.
\item \verb{MRAN@<package>-<version>} MRAN snapshot, for the
day after the release of \verb{<version>} of \verb{<package>}.
\item \verb{MRAN@R-<version>} MRAN snapshot, for the day
after R \verb{<version>} was released.
}

Notes:
\itemize{
\item See more about RSPM at \verb{https://packagemanager.rstudio.com/client/#/}.
\item See more about MRAN snapshots at
\url{https://mran.microsoft.com/timemachine}.
\item All dates (or times) can be specified in the ISO 8601 format.
\item If RSPM does not have a snapshot available for a date, the next
available date is used.
\item Dates that are before the first, or after the last RSPM snapshot
will trigger an error.
\item Dates before the first, or after the last MRAN snapshot will trigger
an error.
\item Unknown R or package versions will trigger an error.
}
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
repo_add(RSPMdplyr100 = "RSPM@dplyr-1.0.0")
repo_get()

repo_resolve("MRAN@2020-01-21")
repo_resolve("RSPM@2020-01-21")
repo_resolve("MRAN@dplyr-1.0.0")
repo_resolve("RSPM@dplyr-1.0.0")
repo_resolve("MRAN@R-4.0.0")
repo_resolve("RSPM@R-4.0.0")
\dontshow{\}) # examplesIf}
}
\seealso{
Other repository functions: 
\code{\link{repo_get}()},
\code{\link{repo_status}()}
}
\concept{repository functions}
