% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{Get started with pak}
\alias{Get started with pak}
\title{Simplified manual. Start here!}
\description{
You don't need to read long manual pages for a simple task.
This manual page collects the most common pak use cases.
}
\section{Package installation}{
\subsection{Install a package from CRAN or Bioconductor}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble")
}\if{html}{\out{</div>}}

\if{html}{\figure{tldr-cran.svg}}

pak automatically sets a CRAN repository and the Bioconductor repositories
that correspons to the current R version.
}

\subsection{Install a package from GitHub}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tidyverse/tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">update</span> 2 packages.                                               
#> → All 2 packages (0 B) are cached.                                      
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.8 → 3.1.8<span style="font-weight: bold;">.9002</span> 👷🏻🔧 (GitHub: 37ec86a)                       
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">vctrs</span>  0.5.1 → 0.5.1<span style="font-weight: bold;">.9000</span> 👷🏾‍♀️🔧 (GitHub: 2d7de76)                    
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 2 pkgs are cached                            
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">vctrs</span> 0.5.1.9000                                            
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">vctrs</span> 0.5.1.9000 <span style="color: #a3a3a3;">(1.4s)</span>                                      
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">vctrs</span> 0.5.1.9000                                             
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">vctrs</span> 0.5.1.9000 <span style="color: #a3a3a3;">(11.2s)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">vctrs</span> 0.5.1.9000 (github::r-lib/vctrs@2d7de76) <span style="color: #a3a3a3;">(34ms)</span>       
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8.9002                                           
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8.9002 <span style="color: #a3a3a3;">(502ms)</span>                                    
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.8.9002                                            
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.8.9002 <span style="color: #a3a3a3;">(2.7s)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8.9002 (github::tidyverse/tibble@37ec86a) <span style="color: #a3a3a3;">(28ms)</span> 
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 9, upd 2 <span style="color: #b8b8b8;">[17.5s]</span>                                
</pre></div>
}}


Use the \code{user/repo} form.
You can specify a branch or tag: \code{user/repo@branch} or \code{user/repo@tag}.
}

\subsection{Install a package from a URL}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install(
  "url::https://cran.r-project.org/src/contrib/Archive/tibble/tibble_3.1.7.tar.gz"
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 1 package.                                               
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                
#> → All 2 packages (38.65 kB) are cached.                                 
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">ellipsis</span>              0.3.2                                           
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span>   3.1.8.9002 → 3.1.<span style="font-weight: bold;">7</span> 👷🏻‍♀️🔧                                    
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 2 pkgs (38.65 kB) are cached                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ellipsis</span> 0.3.2  <span style="color: #a3a3a3;">(18ms)</span>                                      
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.7                                                 
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.7 <span style="color: #a3a3a3;">(2.5s)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.7  <span style="color: #a3a3a3;">(31ms)</span>                                        
#> <span style="color: #859900;">✔</span> 1 pkg + 11 deps: kept 10, upd 1, added 1 <span style="color: #b8b8b8;">[3.3s]</span>                       
</pre></div>
}}


The URL may point to an R package file, made with \verb{R CMD build}, or a
\code{.tar.gz} or \code{.zip} archive of a package tree.
}
}

\section{Package updates}{
\subsection{Update a package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                
#> → The package (724.32 kB) is cached.                                    
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.7 → 3.1.<span style="font-weight: bold;">8</span>                                                  
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (724.32 kB) is cached                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8  <span style="color: #a3a3a3;">(36ms)</span>                                        
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 10, upd 1 <span style="color: #b8b8b8;">[368ms]</span>                               
</pre></div>
}}


\code{pak::pkg_install()} automatically updates the package.
}

\subsection{Update all dependencies of a package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble", upgrade = TRUE)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed                                               
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 11 <span style="color: #b8b8b8;">[278ms]</span>                                      
</pre></div>
}}


\code{upgrade = TRUE} updates the package itself and all of its dependencies, if
necessary.
}

\subsection{Reinstall a package}{

Add \code{?reinstall} to the package name or package reference in general:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble?reinstall")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 1 package.                                               
#> → The package (724.32 kB) is cached.                                    
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span>   3.1.8                                                        
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (724.32 kB) is cached                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8  <span style="color: #a3a3a3;">(60ms)</span>                                        
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 10, added 1 <span style="color: #b8b8b8;">[340ms]</span>                             
</pre></div>
}}

}
}

\section{Dependency lookup}{
\subsection{Dependencies of a CRAN or Bioconductor package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 11 × 32</span>                                                 
#>    ref       type  direct direc…¹ status package version license needs…²
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>     <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> cli       stan… FALSE  FALSE   OK     cli     3.4.1   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 2</span> fansi     stan… FALSE  FALSE   OK     fansi   1.0.3   GPL-2 … FALSE  
#> <span style="color: #c2c2c2;"> 3</span> glue      stan… FALSE  FALSE   OK     glue    1.6.2   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 4</span> lifecycle stan… FALSE  FALSE   OK     lifecy… 1.0.3   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 5</span> magrittr  stan… FALSE  FALSE   OK     magrit… 2.0.3   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 6</span> pillar    stan… FALSE  FALSE   OK     pillar  1.8.1   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 7</span> pkgconfig stan… FALSE  FALSE   OK     pkgcon… 2.0.3   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 8</span> rlang     stan… FALSE  FALSE   OK     rlang   1.0.6   MIT + … FALSE  
#> <span style="color: #c2c2c2;"> 9</span> tibble    stan… TRUE   TRUE    OK     tibble  3.1.8   MIT + … FALSE  
#> <span style="color: #c2c2c2;">10</span> utf8      stan… FALSE  FALSE   OK     utf8    1.2.2   Apache… FALSE  
#> <span style="color: #c2c2c2;">11</span> vctrs     stan… FALSE  FALSE   OK     vctrs   0.5.1   MIT + … FALSE  
#> <span style="color: #999999;"># … with 23 more variables: priority &lt;chr&gt;, md5sum &lt;chr&gt;, sha256 &lt;chr&gt;,</span> 
#> <span style="color: #999999;">#   filesize &lt;int&gt;, built &lt;chr&gt;, platform &lt;chr&gt;, rversion &lt;chr&gt;,</span>        
#> <span style="color: #999999;">#   repotype &lt;chr&gt;, repodir &lt;chr&gt;, target &lt;chr&gt;, deps &lt;list&gt;,</span>           
#> <span style="color: #999999;">#   mirror &lt;chr&gt;, sources &lt;list&gt;, remote &lt;list&gt;, error &lt;list&gt;,</span>          
#> <span style="color: #999999;">#   metadata &lt;list&gt;, dep_types &lt;list&gt;, params &lt;list&gt;, sysreqs &lt;chr&gt;,</span>    
#> <span style="color: #999999;">#   cache_status &lt;chr&gt;, lib_status &lt;chr&gt;, old_version &lt;chr&gt;,</span>            
#> <span style="color: #999999;">#   new_version &lt;chr&gt;, and abbreviated variable names ¹​directpkg, …</span>    
</pre></div>
}}


The results are returned in a data frame.
}

\subsection{Dependency tree of a CRAN / Bioconductor package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_tree("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">tibble </span><span style="font-weight: bold;font-style: italic;color: #525252;">3.1.8</span> <span style="color: #859900;">✨</span>                                                          
#> ├─fansi <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                         
#> ├─lifecycle <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> │ ├─cli <span style="color: #525252;">3.4.1</span> <span style="color: #859900;">✨</span>                                                         
#> │ ├─glue <span style="color: #525252;">1.6.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─rlang <span style="color: #525252;">1.0.6</span> <span style="color: #859900;">✨</span>                                                       
#> ├─magrittr <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                      
#> ├─pillar <span style="color: #525252;">1.8.1</span> <span style="color: #859900;">✨</span>                                                        
#> │ ├─cli                                                                 
#> │ ├─fansi                                                               
#> │ ├─glue                                                                
#> │ ├─lifecycle                                                           
#> │ ├─rlang                                                               
#> │ ├─utf8 <span style="color: #525252;">1.2.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─vctrs <span style="color: #525252;">0.5.1</span> <span style="color: #859900;">✨</span>                                                       
#> │   ├─cli                                                               
#> │   ├─glue                                                              
#> │   ├─lifecycle                                                         
#> │   └─rlang                                                             
#> ├─pkgconfig <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> ├─rlang                                                                 
#> └─vctrs                                                                 
#>                                                                         
#> Key:  <span style="color: #859900;">✨</span> new                                                             
</pre></div>
}}


The results are also silently returned in a data frame.
}

\subsection{Dependency tree of a package on GitHub}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_tree("tidyverse/tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">tidyverse/tibble </span><span style="font-weight: bold;font-style: italic;color: #525252;">3.1.8.9002</span> <span style="color: #859900;">✨👷🏼🔧 </span>                                       
#> ├─fansi <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                         
#> ├─lifecycle <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> │ ├─cli <span style="color: #525252;">3.4.1</span> <span style="color: #859900;">✨</span>                                                         
#> │ ├─glue <span style="color: #525252;">1.6.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─rlang <span style="color: #525252;">1.0.6</span> <span style="color: #859900;">✨</span>                                                       
#> ├─magrittr <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                      
#> ├─pillar <span style="color: #525252;">1.8.1</span> <span style="color: #859900;">✨</span>                                                        
#> │ ├─cli                                                                 
#> │ ├─fansi                                                               
#> │ ├─glue                                                                
#> │ ├─lifecycle                                                           
#> │ ├─rlang                                                               
#> │ ├─utf8 <span style="color: #525252;">1.2.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─r-lib/vctrs <span style="color: #525252;">0.5.1.9000</span> <span style="color: #859900;">✨👷🏼🔧 </span>                                        
#> │   ├─cli                                                               
#> │   ├─glue                                                              
#> │   ├─lifecycle                                                         
#> │   └─rlang                                                             
#> ├─pkgconfig <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> ├─rlang                                                                 
#> └─r-lib/vctrs                                                           
#>                                                                         
#> Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷🏼 </span>build | 🔧<span style="color: #859900;"> </span>compile                                      
</pre></div>
}}


Use the \code{user/repo} form.
As usual, you can also select a branch, tag, or sha, with the
\code{user/repo@branch}, \code{user/repo@tag} or \code{user/repo@sha} forms.
}

\subsection{Dependency tree of the package in the current directory}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_deps_tree("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">local::tibble </span><span style="font-weight: bold;font-style: italic;color: #525252;">3.1.8</span> <span style="color: #859900;">✨👷🏻‍♀️🔧    </span>                                         
#> ├─fansi <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                         
#> ├─lifecycle <span style="color: #525252;">1.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> │ ├─cli <span style="color: #525252;">3.4.1</span> <span style="color: #859900;">✨</span>                                                         
#> │ ├─glue <span style="color: #525252;">1.6.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─rlang <span style="color: #525252;">1.0.6</span> <span style="color: #859900;">✨</span>                                                       
#> ├─magrittr <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                      
#> ├─pillar <span style="color: #525252;">1.8.1</span> <span style="color: #859900;">✨</span>                                                        
#> │ ├─cli                                                                 
#> │ ├─fansi                                                               
#> │ ├─glue                                                                
#> │ ├─lifecycle                                                           
#> │ ├─rlang                                                               
#> │ ├─utf8 <span style="color: #525252;">1.2.2</span> <span style="color: #859900;">✨</span>                                                        
#> │ └─vctrs <span style="color: #525252;">0.5.1</span> <span style="color: #859900;">✨</span>                                                       
#> │   ├─cli                                                               
#> │   ├─glue                                                              
#> │   ├─lifecycle                                                         
#> │   └─rlang                                                             
#> ├─pkgconfig <span style="color: #525252;">2.0.3</span> <span style="color: #859900;">✨</span>                                                     
#> ├─rlang                                                                 
#> └─vctrs                                                                 
#>                                                                         
#> Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷🏻‍♀️ bui</span>ld | 🔧 co<span style="color: #859900;">m</span>pile                                   
</pre></div>
}}


Assuming package is in directory \code{tibble}.
}

\subsection{Explain a recursive dependency}{

How does tibble depend on rlang?

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_explain("tibble", "rlang")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> tibble -&gt; lifecycle -&gt; rlang                                            
#> tibble -&gt; pillar -&gt; lifecycle -&gt; rlang                                  
#> tibble -&gt; pillar -&gt; rlang                                               
#> tibble -&gt; pillar -&gt; vctrs -&gt; lifecycle -&gt; rlang                         
#> tibble -&gt; pillar -&gt; vctrs -&gt; rlang                                      
#> tibble -&gt; rlang                                                         
#> tibble -&gt; vctrs -&gt; lifecycle -&gt; rlang                                   
#> tibble -&gt; vctrs -&gt; rlang                                                
</pre></div>
}}


Use can also use the \code{user/repo} form for packages from GitHub,
\code{url::...} for packages at URLs, etc.
}
}

\section{Package development}{
\subsection{Install dependencies of local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install_deps()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Loading metadata database ... done                                    
#>                                                                         
#> → The package (0 B) is cached.                                          
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed                                               
#> <span style="color: #859900;">✔</span> 10 deps: kept 10 <span style="color: #b8b8b8;">[3.2s]</span>                                               
</pre></div>
}}

}

\subsection{Install local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                
#> → The package (0 B) is cached.                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.8 → 3.1.8 👷🏻‍♂️🔧                                           
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg is cached                              
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">tibble</span> 3.1.8 (source) (96 B)                                      
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8                                                
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(864ms)</span>                                         
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.8                                                 
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(2.4s)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8 (local) <span style="color: #a3a3a3;">(38ms)</span>                                 
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 10, upd 1, dld 1 (NA B) <span style="color: #b8b8b8;">[4.2s]</span>                  
</pre></div>
}}

}

\subsection{Install all dependencies of local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install_dev_deps()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 86 packages.                                             
#> → Will <span style="font-style: italic;">update</span> 2 packages.                                               
#> → All 89 packages (100.53 MB) are cached.                               
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">askpass</span>                1.1                                            
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">base64enc</span>              0.1-3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">bench</span>                  1.1.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">bit</span>                    4.0.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">bit64</span>                  4.0.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">blob</span>                   1.2.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">brio</span>                   1.1.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">bslib</span>                  0.4.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">cachem</span>                 1.0.6                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">callr</span>                  3.7.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">clipr</span>                  0.8.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">colorspace</span>             2.0-3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">covr</span>                   3.6.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">crayon</span>                 1.5.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">curl</span>                   4.3.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">desc</span>                   1.4.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">DiagrammeR</span>             1.0.9                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">diffobj</span>                0.3.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">digest</span>                 0.6.31                                         
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">downloader</span>             0.4                                            
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">dplyr</span>                  1.0.10                                         
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">evaluate</span>               0.19    👷🏿‍♂️                                  
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">farver</span>                 2.1.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">fastmap</span>                1.1.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">formattable</span>            0.2.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">fs</span>                     1.5.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">generics</span>               0.1.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">ggplot2</span>                3.4.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">gridExtra</span>              2.3                                            
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">gtable</span>                 0.3.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">highr</span>                  0.9                                            
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">hms</span>                    1.1.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">htmltools</span>              0.5.4                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">htmlwidgets</span>            1.6.0   👷🏾‍♂️                                  
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">httr</span>                   1.4.4                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">igraph</span>                 1.3.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">influenceR</span>             0.1.0.1                                        
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">isoband</span>                0.2.6                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">jquerylib</span>              0.1.4                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">jsonlite</span>               1.8.4                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">knitr</span>                  1.41                                           
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">labeling</span>               0.4.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">lazyeval</span>               0.2.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">lubridate</span>              1.9.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">Matrix</span>       1.5-1   → 1.5-<span style="font-weight: bold;">3</span>                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">memoise</span>                2.0.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">mime</span>                   0.12                                           
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">mockr</span>                  0.2.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">munsell</span>                0.5.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">nlme</span>         3.1-160 → 3.1-<span style="font-weight: bold;">161</span> 👷‍♂️🔧                                  
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">nycflights13</span>           1.0.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">openssl</span>                2.0.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">pkgbuild</span>               1.4.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">pkgload</span>                1.3.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">praise</span>                 1.0.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">prettyunits</span>            1.1.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">processx</span>               3.8.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">profmem</span>                0.6.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">ps</span>                     1.7.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">purrr</span>                  0.3.5                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">R6</span>                     2.5.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rappdirs</span>               0.3.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">RColorBrewer</span>           1.1-3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">readr</span>                  2.1.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rematch2</span>               2.1.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rex</span>                    1.2.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rmarkdown</span>              2.19    👷‍♂️                                   
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rprojroot</span>              2.0.3                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rstudioapi</span>             0.14                                           
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">sass</span>                   0.4.4                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">scales</span>                 1.2.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">stringi</span>                1.7.8                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">stringr</span>                1.5.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">sys</span>                    3.4.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">testthat</span>               3.1.6                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tidyr</span>                  1.2.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tidyselect</span>             1.2.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">timechange</span>             0.1.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tinytex</span>                0.43    👷🏻‍♂️                                  
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tzdb</span>                   0.3.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">viridis</span>                0.6.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">viridisLite</span>            0.4.1                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">visNetwork</span>             2.1.2                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">vroom</span>                  1.6.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">waldo</span>                  0.4.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">withr</span>                  2.5.0                                          
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">xfun</span>                   0.35                                           
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">yaml</span>                   2.3.6                                          
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 88 pkgs (100.53 MB) are cached               
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8                                                
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">evaluate</span> 0.19                                                
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">nlme</span> 3.1-161                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">R6</span> 2.5.1  <span style="color: #a3a3a3;">(31ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">DiagrammeR</span> 1.0.9  <span style="color: #a3a3a3;">(76ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">RColorBrewer</span> 1.1-3  <span style="color: #a3a3a3;">(72ms)</span>                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">askpass</span> 1.1  <span style="color: #a3a3a3;">(79ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">Matrix</span> 1.5-3  <span style="color: #a3a3a3;">(137ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">base64enc</span> 0.1-3  <span style="color: #a3a3a3;">(125ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bench</span> 1.1.2  <span style="color: #a3a3a3;">(90ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bit64</span> 4.0.5  <span style="color: #a3a3a3;">(44ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bit</span> 4.0.5  <span style="color: #a3a3a3;">(43ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">blob</span> 1.2.3  <span style="color: #a3a3a3;">(41ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">brio</span> 1.1.3  <span style="color: #a3a3a3;">(40ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cachem</span> 1.0.6  <span style="color: #a3a3a3;">(31ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">callr</span> 3.7.3  <span style="color: #a3a3a3;">(53ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">clipr</span> 0.8.0  <span style="color: #a3a3a3;">(89ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">colorspace</span> 2.0-3  <span style="color: #a3a3a3;">(99ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">covr</span> 3.6.1  <span style="color: #a3a3a3;">(58ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">crayon</span> 1.5.2  <span style="color: #a3a3a3;">(75ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">curl</span> 4.3.3  <span style="color: #a3a3a3;">(83ms)</span>                                          
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(684ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bslib</span> 0.4.1  <span style="color: #a3a3a3;">(315ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">desc</span> 1.4.2  <span style="color: #a3a3a3;">(77ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">diffobj</span> 0.3.5  <span style="color: #a3a3a3;">(68ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">digest</span> 0.6.31  <span style="color: #a3a3a3;">(60ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">downloader</span> 0.4  <span style="color: #a3a3a3;">(39ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">dplyr</span> 1.0.10  <span style="color: #a3a3a3;">(39ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">farver</span> 2.1.1  <span style="color: #a3a3a3;">(41ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">fastmap</span> 1.1.0  <span style="color: #a3a3a3;">(38ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">formattable</span> 0.2.1  <span style="color: #a3a3a3;">(43ms)</span>                                   
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">evaluate</span> 0.19 <span style="color: #a3a3a3;">(903ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">fs</span> 1.5.2  <span style="color: #a3a3a3;">(49ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">generics</span> 0.1.3  <span style="color: #a3a3a3;">(46ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ggplot2</span> 3.4.0  <span style="color: #a3a3a3;">(65ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">gridExtra</span> 2.3  <span style="color: #a3a3a3;">(43ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">gtable</span> 0.3.1  <span style="color: #a3a3a3;">(38ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">highr</span> 0.9  <span style="color: #a3a3a3;">(37ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">hms</span> 1.1.2  <span style="color: #a3a3a3;">(39ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">htmltools</span> 0.5.4  <span style="color: #a3a3a3;">(40ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">httr</span> 1.4.4  <span style="color: #a3a3a3;">(40ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">influenceR</span> 0.1.0.1  <span style="color: #a3a3a3;">(17ms)</span>                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">igraph</span> 1.3.5  <span style="color: #a3a3a3;">(96ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">isoband</span> 0.2.6  <span style="color: #a3a3a3;">(68ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">jquerylib</span> 0.1.4  <span style="color: #a3a3a3;">(38ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">jsonlite</span> 1.8.4  <span style="color: #a3a3a3;">(37ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">labeling</span> 0.4.2  <span style="color: #a3a3a3;">(14ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">knitr</span> 1.41  <span style="color: #a3a3a3;">(73ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">lazyeval</span> 0.2.2  <span style="color: #a3a3a3;">(43ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">lubridate</span> 1.9.0  <span style="color: #a3a3a3;">(38ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">memoise</span> 2.0.1  <span style="color: #a3a3a3;">(39ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">mime</span> 0.12  <span style="color: #a3a3a3;">(58ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">mockr</span> 0.2.0  <span style="color: #a3a3a3;">(38ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">munsell</span> 0.5.0  <span style="color: #a3a3a3;">(36ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">nycflights13</span> 1.0.2  <span style="color: #a3a3a3;">(37ms)</span>                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">openssl</span> 2.0.5  <span style="color: #a3a3a3;">(41ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pkgbuild</span> 1.4.0  <span style="color: #a3a3a3;">(39ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pkgload</span> 1.3.2  <span style="color: #a3a3a3;">(37ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">praise</span> 1.0.0  <span style="color: #a3a3a3;">(35ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">prettyunits</span> 1.1.1  <span style="color: #a3a3a3;">(56ms)</span>                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">processx</span> 3.8.0  <span style="color: #a3a3a3;">(37ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">profmem</span> 0.6.0  <span style="color: #a3a3a3;">(37ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ps</span> 1.7.2  <span style="color: #a3a3a3;">(37ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">purrr</span> 0.3.5  <span style="color: #a3a3a3;">(38ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rappdirs</span> 0.3.3  <span style="color: #a3a3a3;">(37ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">readr</span> 2.1.3  <span style="color: #a3a3a3;">(42ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rematch2</span> 2.1.2  <span style="color: #a3a3a3;">(41ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rex</span> 1.2.1  <span style="color: #a3a3a3;">(58ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rprojroot</span> 2.0.3  <span style="color: #a3a3a3;">(58ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rstudioapi</span> 0.14  <span style="color: #a3a3a3;">(40ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">sass</span> 0.4.4  <span style="color: #a3a3a3;">(42ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">scales</span> 1.2.1  <span style="color: #a3a3a3;">(39ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">stringr</span> 1.5.0  <span style="color: #a3a3a3;">(33ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">sys</span> 3.4.1  <span style="color: #a3a3a3;">(49ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">testthat</span> 3.1.6  <span style="color: #a3a3a3;">(88ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tidyr</span> 1.2.1  <span style="color: #a3a3a3;">(77ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">stringi</span> 1.7.8  <span style="color: #a3a3a3;">(195ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tidyselect</span> 1.2.0  <span style="color: #a3a3a3;">(113ms)</span>                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">timechange</span> 0.1.1  <span style="color: #a3a3a3;">(55ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tzdb</span> 0.3.0  <span style="color: #a3a3a3;">(40ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">viridisLite</span> 0.4.1  <span style="color: #a3a3a3;">(39ms)</span>                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">viridis</span> 0.6.2  <span style="color: #a3a3a3;">(39ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">visNetwork</span> 2.1.2  <span style="color: #a3a3a3;">(77ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">vroom</span> 1.6.0  <span style="color: #a3a3a3;">(77ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">waldo</span> 0.4.0  <span style="color: #a3a3a3;">(62ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">withr</span> 2.5.0  <span style="color: #a3a3a3;">(40ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">xfun</span> 0.35  <span style="color: #a3a3a3;">(39ms)</span>                                           
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tinytex</span> 0.43                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">yaml</span> 2.3.6  <span style="color: #a3a3a3;">(43ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">evaluate</span> 0.19  <span style="color: #a3a3a3;">(15ms)</span>                                       
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tinytex</span> 0.43 <span style="color: #a3a3a3;">(1.1s)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tinytex</span> 0.43  <span style="color: #a3a3a3;">(15ms)</span>                                        
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">rmarkdown</span> 2.19                                               
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">rmarkdown</span> 2.19 <span style="color: #a3a3a3;">(3.9s)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rmarkdown</span> 2.19  <span style="color: #a3a3a3;">(85ms)</span>                                      
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">htmlwidgets</span> 1.6.0                                            
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">nlme</span> 3.1-161 <span style="color: #a3a3a3;">(8s)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">nlme</span> 3.1-161  <span style="color: #a3a3a3;">(33ms)</span>                                        
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">htmlwidgets</span> 1.6.0 <span style="color: #a3a3a3;">(1.1s)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">htmlwidgets</span> 1.6.0  <span style="color: #a3a3a3;">(22ms)</span>                                   
#> <span style="color: #859900;">✔</span> 103 deps: kept 15, upd 2, added 86 <span style="color: #b8b8b8;">[10.2s]</span>                            
</pre></div>
}}


Installs development and optional dependencies as well.
}
}

\section{Repositories}{
\subsection{List current repositories}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                   
#>   name          url                                type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                              <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org        cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>         
</pre></div>
}}


If you haven't set a CRAN or Bioconductor repository, pak does that
automatically.
}

\subsection{Add custom repository}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(rhub = 'https://r-hub.r-universe.dev')
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 6 × 5</span>                                                   
#>   name          url                                type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                              <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org        cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> rhub          https://r-hub.r-universe.dev       cran… *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">3</span> BioCsoft      https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">4</span> BioCann       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">5</span> BioCexp       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">6</span> BioCworkflows https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>         
</pre></div>
}}

}

\subsection{Remove custom repositories}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(repos = getOption("repos")["CRAN"])
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                   
#>   name          url                                type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                              <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org        cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>         
</pre></div>
}}


If you set the \code{repos} option to a CRAN repo only, or unset it completely,
then pak keeps only CRAN and (by default) Bioconductor.
}

\subsection{Time travel using RSPM}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(CRAN = "RSPM@2022-06-30")
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                   
#>   name          url                                type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                              <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://packagemanager.posit.co/c… cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>         
</pre></div>
}}


Sets a repository that is equivalent to CRAN's state closest to the
specified date.
Name this repository \code{CRAN}, otherwise pak will also add a default CRAN
repository.
}

\subsection{Time travel using MRAN}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(CRAN = "MRAN@2022-06-30")
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                   
#>   name          url                                type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                              <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cran.microsoft.com/snapsh… cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages… bioc  4.2.2   3.16   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>         
</pre></div>
}}


Sets a repository that is equivalent to CRAN's state at the specified date.
Name this repository \code{CRAN}, otherwise pak will also add a default CRAN
repository.
}
}

\section{Caches}{
By default pak caches both metadata and downloaded packages.
\subsection{Inspect metadata cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_list()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Updated metadata database: 4.55 MB in 4 files.                        
#> <span style="color: #859900;">✔</span> Updating metadata database ... done                                   
#> <span style="color: #999999;"># A data frame: 43,718 × 32</span>                                             
#>    package version depends sugge…¹ license imports linki…² archs enhan…³
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> A3      1.0.0   R (&gt;= … random… GPL (&gt;… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 2</span> AATtoo… 0.0.1   R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL-3   magrit… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 3</span> ABACUS  1.0.0   R (&gt;= … rmarkd… GPL-3   ggplot… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 4</span> ABC.RAP 0.9.0   R (&gt;= … knitr,… GPL-3   graphi… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 5</span> ABCana… 1.2.1   R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL-3   plotrix <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 6</span> ABCopt… 0.15.0  <span style="color: #DC322F;">NA</span>      testth… MIT + … Rcpp, … Rcpp    ABCo… <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 7</span> ABCp2   1.2     MASS    <span style="color: #DC322F;">NA</span>      GPL-2   <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 8</span> ABHgen… 1.0.1   <span style="color: #DC322F;">NA</span>      knitr,… GPL-3   ggplot… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 9</span> ABPS    0.3     <span style="color: #DC322F;">NA</span>      testth… GPL (&gt;… kernlab <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">10</span> ACA     1.1     R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL     graphi… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #999999;"># … with 43,708 more rows, 23 more variables: os_type &lt;chr&gt;,</span>            
#> <span style="color: #999999;">#   priority &lt;chr&gt;, license_is_foss &lt;chr&gt;, license_restricts_use &lt;chr&gt;,</span> 
#> <span style="color: #999999;">#   repodir &lt;chr&gt;, rversion &lt;chr&gt;, platform &lt;chr&gt;,</span>                      
#> <span style="color: #999999;">#   needscompilation &lt;chr&gt;, ref &lt;chr&gt;, type &lt;chr&gt;, direct &lt;lgl&gt;,</span>        
#> <span style="color: #999999;">#   status &lt;chr&gt;, target &lt;chr&gt;, mirror &lt;chr&gt;, sources &lt;list&gt;,</span>           
#> <span style="color: #999999;">#   filesize &lt;int&gt;, sha256 &lt;chr&gt;, sysreqs &lt;chr&gt;, built &lt;chr&gt;,</span>           
#> <span style="color: #999999;">#   published &lt;dttm&gt;, deps &lt;list&gt;, md5sum &lt;chr&gt;, path &lt;chr&gt;, and …</span>      
</pre></div>
}}

}

\subsection{Update metadata cache}{

By default \code{pkg_install()} and similar functions automatically update the
metadata for the currently set repositories if it is older than 24 hours.
You can also force an update manually:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_update()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Updating metadata database ... done                                   
</pre></div>
}}

}

\subsection{Clean metadata cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_clean(force = TRUE)
pak::meta_summary()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/_metad
#> ata"                                                                    
#>                                                                         
#> $current_db                                                             
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/_metad
#> ata/pkgs-d1c324e625.rds"                                                
#>                                                                         
#> $raw_files                                                              
#> character(0)                                                            
#>                                                                         
#> $db_files                                                               
#> character(0)                                                            
#>                                                                         
#> $size                                                                   
#> [1] 0                                                                   
#>                                                                         
</pre></div>
}}

}

\subsection{Inspect package cache}{

Downloaded packages are also cached.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_list()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 480 × 11</span>                                                
#>    fullpath       path  package url   etag  sha256 version platf…¹ built
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>          <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;int&gt;</span>
#> <span style="color: #c2c2c2;"> 1</span> /Users/gaborc… arch… <span style="color: #DC322F;">NA</span>      http… <span style="color: #999999;">"</span>\\"1… 0c8f0… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>         <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 2</span> /Users/gaborc… bin/… evalua… http… <span style="color: #999999;">"</span>\\"1… 08a39… 0.17    aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 3</span> /Users/gaborc… bin/… crayon  http… <span style="color: #999999;">"</span>\\"2… 1e6d5… 1.5.2   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 4</span> /Users/gaborc… bin/… common… http… <span style="color: #999999;">"</span>\\"4… 47b4a… 1.8.1   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 5</span> /Users/gaborc… bin/… curl    http… <span style="color: #999999;">"</span>\\"b… 7b8ba… 4.3.3   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 6</span> /Users/gaborc… bin/… tinytex http… <span style="color: #999999;">"</span>\\"2… 7e9ba… 0.42    aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 7</span> /Users/gaborc… bin/… jsonli… http… <span style="color: #999999;">"</span>\\"1… 68e59… 1.8.2   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 8</span> /Users/gaborc… bin/… lifecy… http… <span style="color: #999999;">"</span>\\"1… 7ce27… 1.0.3   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;"> 9</span> /Users/gaborc… bin/… vctrs   http… <span style="color: #999999;">"</span>\\"1… c3a69… 0.4.2   aarch6…    <span style="color: #DC322F;">NA</span>
#> <span style="color: #c2c2c2;">10</span> /Users/gaborc… src/… pkgcac… <span style="color: #DC322F;">NA</span>     <span style="color: #DC322F;">NA</span>   9b70a… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>          0
#> <span style="color: #999999;"># … with 470 more rows, 2 more variables: vignettes &lt;int&gt;,</span>              
#> <span style="color: #999999;">#   rversion &lt;chr&gt;, and abbreviated variable name ¹​platform</span>            
</pre></div>
}}

}

\subsection{View a package cache summary}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_summary()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> $cachepath                                                              
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/pkg"  
#>                                                                         
#> $files                                                                  
#> [1] 480                                                                 
#>                                                                         
#> $size                                                                   
#> [1] 653325143                                                           
#>                                                                         
</pre></div>
}}

}

\subsection{Clean package cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_clean()
}\if{html}{\out{</div>}}
}
}

\section{Libraries}{
\subsection{List packages in a library}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::lib_status(Sys.getenv("R_LIBS_USER"))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 701 × 39</span>                                                
#>    library   package title version depends repos…¹ license needs…² built
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>     <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>
#> <span style="color: #c2c2c2;"> 1</span> /Users/g… abc     <span style="color: #999999;">"</span>Too… 2.2.1   R (&gt;= … CRAN    GPL (&gt;… FALSE   R 4.…
#> <span style="color: #c2c2c2;"> 2</span> /Users/g… abc.da… <span style="color: #999999;">"</span>Dat… 1.0     R (&gt;= … CRAN    GPL (&gt;… FALSE   R 4.…
#> <span style="color: #c2c2c2;"> 3</span> /Users/g… abind   <span style="color: #999999;">"</span>Com… 1.4-5   R (&gt;= … CRAN    LGPL (… FALSE   R 4.…
#> <span style="color: #c2c2c2;"> 4</span> /Users/g… ade4    <span style="color: #999999;">"</span>Ana… 1.7-19  R (&gt;= … CRAN    GPL (&gt;… TRUE    R 4.…
#> <span style="color: #c2c2c2;"> 5</span> /Users/g… ape     <span style="color: #999999;">"</span>Ana… 5.6-2   R (&gt;= … CRAN    GPL-2 … TRUE    R 4.…
#> <span style="color: #c2c2c2;"> 6</span> /Users/g… aplot   <span style="color: #999999;">"</span>Dec… 0.1.7   <span style="color: #DC322F;">NA</span>      CRAN    Artist… FALSE   R 4.…
#> <span style="color: #c2c2c2;"> 7</span> /Users/g… archive <span style="color: #999999;">"</span>Mul… 1.1.5   R (&gt;= … CRAN    MIT + … TRUE    R 4.…
#> <span style="color: #c2c2c2;"> 8</span> /Users/g… arrayh… <span style="color: #999999;">"</span>Con… 1.1-0   <span style="color: #DC322F;">NA</span>      CRAN    GPL     FALSE   R 4.…
#> <span style="color: #c2c2c2;"> 9</span> /Users/g… arrow   <span style="color: #999999;">"</span>Int… 9.0.0   R (&gt;= … CRAN    Apache… TRUE    R 4.…
#> <span style="color: #c2c2c2;">10</span> /Users/g… arules  <span style="color: #999999;">"</span>Min… 1.7-5   R (&gt;= … CRAN    GPL-3   TRUE    R 4.…
#> <span style="color: #999999;"># … with 691 more rows, 30 more variables: remotetype &lt;chr&gt;,</span>            
#> <span style="color: #999999;">#   remotepkgref &lt;chr&gt;, remoteref &lt;chr&gt;, remoterepos &lt;chr&gt;,</span>             
#> <span style="color: #999999;">#   remotepkgplatform &lt;chr&gt;, remotesha &lt;chr&gt;, imports &lt;chr&gt;,</span>            
#> <span style="color: #999999;">#   suggests &lt;chr&gt;, linkingto &lt;chr&gt;, remotes &lt;chr&gt;, remotehost &lt;chr&gt;,</span>   
#> <span style="color: #999999;">#   remoterepo &lt;chr&gt;, remoteusername &lt;chr&gt;, enhances &lt;chr&gt;,</span>             
#> <span style="color: #999999;">#   biocviews &lt;chr&gt;, remoteurl &lt;chr&gt;, remotesubdir &lt;chr&gt;,</span>               
#> <span style="color: #999999;">#   priority &lt;chr&gt;, remoteetag &lt;chr&gt;, remotepackaged &lt;chr&gt;, …</span>           
</pre></div>
}}


Pass the directory of the library as the argument.
}
}

