\name{ESD}
\alias{ESD}

\title{
Compute Expected Squared Divergence (ESD) for simple evolutionary models
}
\description{
 Computes for a specified model and duration of time the expected squared divergence (ESD), which is a useful measure of the magnitude and rate of change across different models. 
}
\usage{
ESD(y, dt, model = c("GRW", "URW", "Stasis", "allThree"), method = c("Joint", "AD"), 
    pool = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{
a \code{paleoTS} object
}
  \item{dt}{
the time interval to evaluate ESD
}
  \item{model}{
the model of evolution to assume. See Details.
}
  \item{method}{
Joint or AD parameterization
}
  \item{pool}{
if the variances across samples should be pooled; default is TRUE.
}
  \item{\dots}{
other arguments to the model-fitting functions
}
}
\details{
Hunt (2012) argued that rate metrics make sense only in the context of specific models of evolution.  It is thus difficult to meaningfully compare rates across sequences generated by different evolutionary processes.  ESD values can be used for a specified model and duration as a comparable measure of the amount of evolutionary change that is expected.

Acceptable values for the model argument can be "GRW" for the general random walk (directional change), "URW" for the unbiased random walk, and "Stasis."  In addition, can also specify "allThree", in which case all these models will be fit and the resulting ESD will be the wieghted average of them, using model support (Akaike weights) for the weighting (see Hunt [2012], p. 370)
}
\value{
the ESD value
}
\references{
Hunt, G. 2012. Fitting and comparing models of phyletic evolution: random walks and beyond.  \emph{Paleobiology} \bold{ 38}:351--373.  \cr
}
\author{
Gene Hunt
}

\examples{
  # simulate random walk
  x<- sim.GRW(ns=20)
  esd.urw<- ESD(x, dt=10, model="URW")
  esd.all<- ESD(x, dt=10, model="allThree") 
  
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}
\keyword{ts}
