% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopal.R, R/pals.R
\docType{data}
\name{autocol}
\alias{autocol}
\alias{pals.misc}
\alias{pals.viridis}
\alias{pals.rcolorbrewer}
\title{Map Colours From Value}
\format{
An object of class \code{list} of length 1.

An object of class \code{list} of length 8.

An object of class \code{list} of length 35.
}
\usage{
autocol(
  x,
  set = "",
  alpha = NA,
  limits = NA,
  na_colour = NA,
  bias = 1,
  legend_len = 6
)

pals.misc

pals.viridis

pals.rcolorbrewer
}
\arguments{
\item{x}{Vector to be mapped to colours}

\item{set}{Colour set to use -- see Details for full list. A default \code{sasha} or \code{viridis} is chosen if empty.}

\item{alpha}{Transparency as a single value or as another vector (recycled to fill).
If it is a vector, all values are scaled from 0:max(alpha) meaning transparent:opaque.
Single values must be in range 0-1. If \code{NA} no alpha channel is added.}

\item{limits}{Colour scale limits as absolute range \code{c(0,10)} or \code{NA} = full range}

\item{na_colour}{Colour to represent NA-values, default \code{NA} returns a colour of \code{NA} (thus not plotted)}

\item{bias}{Skew to apply to colour-ramp (>1 increases resolution at low end, <1 at the high end)}

\item{legend_len}{Continuous legend target size}
}
\value{
A character vector of colours of equal length to input \code{x}, sampled from the chosen \code{set}.
This allows it to be used for plotting directly. Information for a legend (containing every
level for categorical data, or approximately length \code{legend_len} for continuous) is stored in
\code{options('autolegend')} and not returned explicitly.
}
\description{
Create a vector of colours and associated legend for easier base plots
}
\details{
Helper function for using colours in R's default \code{plot()} and \code{legend()}. Colours
from built-in palettes are automatically scaled to return a vector of colours
and create \code{options('autolegend')} which contains the correct legend mapping for
\code{autolegend()}.

A discrete palette is used for factor and character inputs whilst a
continuous palette is used for integer and numeric.

Colour sets built-in so far are held in lists starting \code{pals.} and can be
visualized most easily with \code{pals_display()}. The \code{set} argument can be
any of the colour set names listed here (such as 'magma'), or from \code{palette.pals()},
or finally as a custom-defined vector, such as \code{set = rainbow(5)}.

The current lists of palettes included with paletteknife all being with \code{pal.}
\itemize{
\item \strong{\code{pals.viridis}}

All of the continuous palette forked from the \code{viridisLite} package maintained by Simon Garnier.
\itemize{
\item Contains: \code{cividis} \code{inferno} \code{magma} \code{mako} \code{plasma} \code{rocket} \code{turbo} \code{viridis}
}
\item \strong{\code{pals.rcolorbrewer}}

All of the palettes included in RColorBrewer
\itemize{
\item Categorical:
\code{Accent} \code{Set1} \code{Set2} \code{Set3} \code{Paired} \code{Pastel1} \code{Pastel2} \code{Dark2}
\item Continuous:
\code{Greys} \code{Blues} \code{BuGn} \code{BuPu} \code{Greens} \code{GnBu} \code{PuBu} \code{Purples} \code{PuBuGn}
\code{YlGnBu} \code{YlGn}
\code{YlOrBr} \code{YlOrRd} \code{Oranges} \code{OrRd} \code{Reds} \code{RdPu} \code{PuRd}
\item Divergent:
\code{Spectral} \code{RdYlBu} \code{RdYlGn}
\code{BrBG} \code{RdBu} \code{RdGy} \code{PiYG} \code{PRGn} \code{PuOr}
}
\item \strong{\code{pals.misc}}
\itemize{
\item Sasha Trubetskoy  (2017): \emph{List of 20 Simple, Distinct Colors}: \code{sasha}
}
}

Custom limits can be specified using \code{c(0,10)}. This is useful if multiple
plots using the same range are required for cross-comparison. Default
behaviour (\code{limits = NA}) sets the range to exactly fit.

The skew of the colourscale can be adjusted with \code{bias}, for example if \code{x}
has an exponential distribution, a bias value > 1 will bring out contrast at
the low end.
}
\examples{
plot(iris$Sepal.Length, iris$Petal.Length, cex=3, pch=16,
    col=autocol(iris$Petal.Width, set='PuBuGn', alpha=0.8, legend_len=12) )
  autolegend('topleft', title='Petal.Width', ncol=3)
  # Also try simplest "autolegend()" for click-to-draw

# Try scales which include NA in both colour and alpha channel
with(airquality, plot(Temp, col=autocol(x=Solar.R, set='YlOrRd', alpha=Ozone,
    na_colour='cyan'), pch=16, cex=sqrt(Wind) ))
  # Note inset=1 draws on opposite side ie above not below plot area
  autolegend('bottom', inset=1, bty='n', horiz=TRUE)


# Here we want a summary plot ordered by level, so need to create a colour vector to match
# 'Alphabet' is a built-in colour set, see "palette.pals()"
mixedbag = as.factor(sample(letters,1000,replace=TRUE))
  plot(x=mixedbag, y=rnorm(1000), col=autocol(levels(mixedbag), set='Alphabet'))
  autolegend('bottom', ncol=9, cex=0.7)

# Maintain the order of strings
barplot(1:8, col=autocol(LETTERS[8:1]))
  autolegend('topleft')

# Any unusual formats are coerced to numeric and the legend converted back
mydates = as.Date('2000-01-01')+0:100
  plot(mydates, pch=16, col=autocol(mydates, set=rainbow(10), bias=2) )
  autolegend(x=0, y=mydates[100], title='My Dates')

# Timeseries objects plot as a line, but can overlay with points()
plot(airmiles)
  points(airmiles, pch=15, col=autocol(airmiles, set='Reds'))

# Use the limits to clip or augment the colour-scale
layout(matrix(1:2))
  plot(runif(10), col=autocol(1:10, limits=c(0,20)), pch=16,
    main='Data split over two plots with same scale')
  plot(runif(10), col=autocol(c(100,20:12), limits=c(0,20)), pch=16)
  text(1, 0.5, pos=4, xpd=NA,
'This point has a
value of 100 but
clipped to max
colour == 20')
  autolegend('bottom', inset=1, horiz=TRUE) # Draws above!
  layout(1)

}
\keyword{datasets}
