% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotDistro.R
\name{PlotDistro}
\alias{PlotDistro}
\title{Plot a value relative to a background distribution from a palmprint
  data.frame.}
\usage{
PlotDistro(
  pp,
  pp.bg,
  plotValue,
  distrocol = "skyblue",
  set.ylab = "palmDB density"
)
}
\arguments{
\item{pp}{A palmprint.df row to use for the plot "value"}

\item{pp.bg}{A multiple palmprint.df  for the plot background "distribution"}

\item{plotValue}{Which numeric column to use for pp and pp.bg. One of
"score", "pssm_total_score", "pp_length", "v1_length", "v2_length"}

\item{distrocol}{Color to use for distribution ["skyblue"]}

\item{set.ylab}{Label for y-axis ["palmDB density"]}
}
\value{
A ggplot2 object
}
\description{
Plot a value relative to a background distribution from a palmprint
  data.frame.
}
\examples{

data("waxsys.palmprint")
data("palmdb")

PlotDistro( pp = waxsys.palmprint, pp.bg = palmdb, "score", "black")
PlotDistro( pp = waxsys.palmprint, pp.bg = palmdb, "pp_length", "skyblue")

}
\keyword{fev}
\keyword{palmid}
