% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.dist}
\alias{pal.dist}
\title{Measure the pointwise distance between two palettes}
\usage{
pal.dist(pal1, pal2, n = 255)
}
\arguments{
\item{pal1}{A color palette (function or vector)}

\item{pal2}{A color palette (function or vector)}

\item{n}{Number of colors to use, default 255}
}
\value{
A vector of n distances.
}
\description{
Measure the pointwise distance between two palettes
}
\details{
The distance between two palettes (of equal length) is calculated pointwise using
the Lab color space.  A 'just noticeable difference' between colors is roughly 2.3.
}
\examples{
pa0 <- c("#ff0000","#00ff00","#0000ff")
pa1 <- c("#fa0000","#00fa00","#0000fa") # 2.4
pa2 <- c("#f40000","#00f400","#0000f4") # 5.2
pal.dist(pa0,pa1) # 1.87, 2.36, 2.11
pal.dist(pa0,pa2) # 4.12 5.20 4.68
pal.bands(pa1,pa0,pa2, labels=c("1.87  2.36  2.11","0","4.12  5.20  4.68"))
title("Lab distances from middle palette")

}
\references{
https://en.wikipedia.org/wiki/Color_difference
}
\author{
Kevin Wright
}
