% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pexp.R
\name{add_tdc}
\alias{add_tdc}
\title{Add time-dependent covariate to a data set}
\usage{
add_tdc(data, tz, rng_fun, ...)
}
\arguments{
\item{data}{A data set with variables specified in \code{formula}.}

\item{tz}{A numeric vector of exposure times (relative to the
beginning of the follow-up time \code{t})}

\item{rng_fun}{A random number generating function that creates
the time-dependent covariates at time points \code{tz}.
First argument of the function should be \code{n}, the number of
random numbers to generate. Within \code{add_tdc}, \code{n} will be set
to \code{length(tz)}.}

\item{...}{Currently not used.}
}
\description{
Given a data set in standard format (with one row per subject/observation),
this function adds a column with the specified exposure time points
and a column with respective exposures, created from \code{rng.fun}.
This function should usually only be used to create data sets passed
to \code{\link[pammtools]{sim_pexp}}.
}
