\name{pamr.listgenes}
\alias{pamr.listgenes}
    \title{ A function to list the genes that survive the thresholding,
 	from the nearest shrunken centroid classifier}
\description{ A function to list the genes that survive the thresholding,
 	from the nearest shrunken centroid classifier produced by pamr.train}
   
}
\usage{
pamr.listgenes(fit, data, threshold, genenames=F)
}

\arguments{
\item{fit}{The result of a call to pamr.train}
    \item{data}{The input data.  In the same format as the input data for
                  pamr.train}

\item{threshold}{The desired threshold value}
\item{genenames}{Include genenames in the list? If yes, they
    are taken from "data". Default is false (geneid is always included
    in the list).}
}    
    
\details{
    \code{pamr.listgenes} List the geneids, and standardized centroids for
    each class, for genes surviving at the given threshold.
}


   \references{}

   
 

\author{ Trevor Hastie, Robert Tibshirani, Balasubramanian Narasimhan, and Gilbert Chu  }

\examples{
set.seed(120)
x <- matrix(rnorm(1000*20),ncol=20)
y <- sample(c(1:4),size=20,replace=TRUE)
mydata <- list(x=x,y=y,geneid=as.character(1:1000))
mytrain <-   pamr.train(mydata)
mycv <- pamr.cv(mytrain,mydata)
pamr.listgenes(mytrain, mydata, threshold=1.6)
 
}
\keyword{ }

