% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_data.R
\name{pg_data}
\alias{pg_cache_clear}
\alias{pg_cache_list}
\alias{pg_data}
\title{Download data from Pangaea.}
\usage{
pg_data(doi, path = "~/.pangaea/", overwrite = TRUE, ...)

pg_cache_clear(path = "~/.pangaea/", doi = NULL, prompt = TRUE)

pg_cache_list(path = "~/.pangaea/")
}
\arguments{
\item{doi}{DOI of Pangaeae single dataset, or of a collection of datasets.}

\item{path}{(character) Path to store files in. Default: \emph{"~/.pangaea/"}}

\item{overwrite}{(logical) Ovewrite a file if one is found with the same name}

\item{...}{Curl debugging options passed on to \code{\link[httr]{GET}}}

\item{prompt}{(logical) Prompt before clearing all files in cache? No prompt used when DOIs
assed in. Default: TRUE}
}
\value{
One or more items of class pangaea, each with a citation object, metadata object,
and data object. Each data object is printed as a \code{tbl_df} object, but the
actual object is simply a \code{data.frame}.
}
\description{
Grabs data as a dataframe or list of dataframes from a Pangaea data repository URI; see:
\url{http://www.pangaea.de/}.
}
\examples{
\dontrun{
# a single file
res <- pg_data(doi='10.1594/PANGAEA.807580')
res
res[[1]]$citation
res[[1]]$meta

# another single file
pg_data(doi='10.1594/PANGAEA.807584')

# Many files
res <- pg_data(doi='10.1594/PANGAEA.807587')
res[[3]]

# Another example of many files
res <- pg_data(doi='10.1594/PANGAEA.761032')
res[[1]]
res[[2]]

# Manipulating the cache
## list files in the cache
pg_cache_list()

## clear all data
# pg_cache_clear()
pg_cache_list()

## clear a single dataset by DOI
pg_data(doi='10.1594/PANGAEA.812093')
pg_cache_list()
pg_cache_clear(doi='10.1594/PANGAEA.812093')
pg_cache_list()

## clear more than 1 dataset by DOI
lapply(c('10.1594/PANGAEA.746398','10.1594/PANGAEA.746400'), pg_data)
pg_cache_list()
pg_cache_clear(doi=c('10.1594/PANGAEA.746398','10.1594/PANGAEA.746400'))
pg_cache_list()
}
}
\author{
Naupaka Zimmerman
}

