% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_efa_to_cfa.R
\name{convert_efa_to_cfa}
\alias{convert_efa_to_cfa}
\alias{convert_efa_to_cfa.fa}
\alias{efa_to_cfa}
\title{Conversion between EFA results and CFA structure}
\usage{
convert_efa_to_cfa(model, ...)

\method{convert_efa_to_cfa}{fa}(model, threshold = "max", names = NULL, ...)

efa_to_cfa(model, ...)
}
\arguments{
\item{model}{An EFA model (e.g., a \code{psych::fa} object).}

\item{...}{Arguments passed to or from other methods.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values
from the loadings should be removed. An integer higher than 1 indicates the
n strongest loadings to retain. Can also be \code{"max"}, in which case it
will only display the maximum loading per variable (the most simple
structure).}

\item{names}{Vector containing dimension names.}
}
\value{
Converted index.
}
\description{
Enables a conversion between Exploratory Factor Analysis (EFA) and
Confirmatory Factor Analysis (CFA) \code{lavaan}-ready structure.
}
\examples{
\donttest{
library(parameters)
if (require("psych") && require("lavaan")) {
  efa <- psych::fa(attitude, nfactors = 3)

  model1 <- efa_to_cfa(efa)
  model2 <- efa_to_cfa(efa, threshold = 0.3)

  anova(
    lavaan::cfa(model1, data = attitude),
    lavaan::cfa(model2, data = attitude)
  )
}
}
}
