% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_scores.R
\name{factor_scores}
\alias{factor_scores}
\title{Extract factor scores from Factor Analysis (EFA) or Omega}
\usage{
factor_scores(x, ...)
}
\arguments{
\item{x}{An object returned by \code{\link[psych:fa]{psych::fa()}}, \code{\link[=factor_analysis]{factor_analysis()}}, or
\code{\link[psych:omega]{psych::omega()}}.}

\item{...}{Currently unused.}
}
\value{
A data frame with the factor scores. It simply extracts the \verb{$scores}
element from the object and converts it into a data frame.
}
\description{
\code{factor_scores()} extracts the factor scores from objects returned by
\code{\link[psych:fa]{psych::fa()}}, \code{\link[=factor_analysis]{factor_analysis()}}, or \code{\link[psych:omega]{psych::omega()}}
}
\examples{
\dontshow{if (insight::check_if_installed("psych", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(mtcars)
out <- factor_analysis(mtcars[, 1:7], n = 2)
head(factor_scores(out))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=factor_analysis]{factor_analysis()}}
}
