% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters_mixed.R
\name{model_parameters.merMod}
\alias{model_parameters.merMod}
\alias{model_parameters.glmmTMB}
\title{Mixed Model Parameters}
\usage{
\method{model_parameters}{merMod}(model, ci = 0.95, bootstrap = FALSE,
  p_method = "wald", ci_method = "wald", iterations = 1000,
  standardize = NULL, exponentiate = FALSE, ...)

\method{model_parameters}{glmmTMB}(model, ci = 0.95, bootstrap = FALSE,
  iterations = 1000, component = c("all", "conditional", "zi",
  "zero_inflated"), standardize = NULL, exponentiate = FALSE, ...)
}
\arguments{
\item{model}{A mixed model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{bootstrap}{Should estimates be based on bootstrapped model? If \code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also \code{\link[=parameters_bootstrap]{parameters_bootstrap()}}).}

\item{p_method}{Method for computing p values. See \code{\link[=p_value]{p_value()}}.}

\item{ci_method}{Method for computing confidence intervals (CI). See \code{\link[=ci.merMod]{ci()}}.}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootstrapped frequentist models.}

\item{standardize}{The method used for standardizing the parameters. Can be \code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"} or \code{NULL} (default) for no standardization. See 'Details' in \code{\link[effectsize]{standardize_parameters}}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the the coefficients (and related confidence intervals). This is typical for, say, logistic regressions, or more generally speaking: for models with log or logit link.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters of (linear) mixed models.
}
\examples{
library(parameters)
library(lme4)
library(glmmTMB)

model <- lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model)

model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)
model_parameters(model)
\donttest{
model <- lme4::lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, bootstrap = TRUE, iterations = 50)
}

}
\seealso{
\code{\link[=standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
