% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_model.R
\name{simulate_model}
\alias{simulate_model}
\alias{simulate_model.glmmTMB}
\title{Simulated draws from model coefficients}
\usage{
simulate_model(model, iterations = 1000, ...)

\method{simulate_model}{glmmTMB}(
  model,
  iterations = 1000,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{Statistical model (no Bayesian models).}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame.
}
\description{
Simulate draws from a statistical model to return a data frame of estimates.
}
\details{
\subsection{Technical Details}{
    \code{simulate_model()} is a computationally faster alternative
    to \code{bootstrap_model()}. Simulated draws for coefficients are based
    on a multivariate normal distribution (\code{MASS::mvrnorm()}) with mean
    \code{mu = coef(model)} and variance \code{Sigma = vcov(model)}.
  }
  \subsection{Models with Zero-Inflation Component}{
    For models from packages \pkg{glmmTMB}, \pkg{pscl}, \pkg{GLMMadaptive} and
    \pkg{countreg}, the \code{component} argument can be used to specify
    which parameters should be simulated. For all other models, parameters
    from the conditional component (fixed effects) are simulated. This may
    include smooth terms, but not random effects.
  }
}
\examples{
library(parameters)
model <- lm(Sepal.Length ~ Species * Petal.Width + Petal.Length, data = iris)
head(simulate_model(model))

\donttest{
if (require("glmmTMB")) {
  model <- glmmTMB(
    count ~ spp + mined + (1 | site),
    ziformula = ~mined,
    family = poisson(),
    data = Salamanders
  )
  head(simulate_model(model))
  head(simulate_model(model, component = "zero_inflated"))
}
}
}
\seealso{
\code{\link[=simulate_parameters]{simulate_parameters()}},
\code{\link[=bootstrap_model]{bootstrap_model()}},
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}
}
