% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_rfv.R
\encoding{UTF-8}
\name{convert_rfv}
\alias{convert_rfv}
\title{Searches columns for given reason for visit defined by ERFV codes.}
\usage{
convert_rfv(
  d,
  code = "rfv_concept_id",
  codes_to_find = NULL,
  collapse = NULL,
  code_time = "time_rfv_start",
  time_type = "earliest",
  nThread = parallel::detectCores() - 1
)
}
\arguments{
\item{d}{data.table, database containing reason for visit information data loaded using the \emph{load_rfv} function.}

\item{code}{string vector, an array of column names to search.}

\item{codes_to_find}{list, a list of arrays corresponding to sets of ERFV codes. The function searches the columns in code and the name of each list element will be created.
These columns are indicators whether the given disease is present in the set of ERFV codes or not.}

\item{collapse}{string, a column name on which to collapse the data.table.
Used in case we wish to assess whether given ERFV are present within all the same instances of \emph{collapse}. See vignette for details.}

\item{code_time}{string, column name of the time column. Defaults to \emph{time_rfv_start}. Used in case collapse is present to provide the earliest or latest instance of diagnosing the given disease.}

\item{time_type}{string, if multiple diagnoses are present within the same case of \emph{collapse}, which timepoint to return. Supported are: "earliest" or "latest". Defaults to \emph{earliest}.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.
On windows machines sockets are used, while on other operating systems fork parallelization is used.}
}
\value{
data.table, with indicator columns if provided.
If \emph{collapse} is present, then only unique ID and the summary columns are returned.
}
\description{
Analyzes reason for visit data loaded using \emph{load_rfv}.
If requested, the data.table is returned with new columns corresponding to boolean values, whether given group of ERFV are present in the given columns.
If \emph{collapse} is given, then the information is aggregated based-on the \emph{collapse} column and the earliest of latest time of the given diagnosis is provided.
}
\examples{
\dontrun{
#Parse reason for visit columns
#and create indicator variables for the following reasons and summarize per patient,
#whether there are any encounters where the given reasons were registered
reasons <- list(Pain = c("ERFV:160357", "ERFV:140012"), Visit = c("ERFV:501"))
data_rfv_disease <-  convert_rfv(d = data_rfv, keep = FALSE,
codes_to_find = reasons, nThread = 2, collapse = "ID_MERGE")
}
}
