% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_node.R
\name{rmd_node}
\alias{rmd_node}
\alias{rmd_node_label}
\alias{rmd_node_type}
\alias{rmd_node_length}
\alias{rmd_node_content}
\alias{rmd_node_attr}
\alias{rmd_node_engine}
\alias{rmd_node_options}
\alias{rmd_node_code}
\title{rmd node utility functions}
\usage{
rmd_node_label(x, ...)

rmd_node_type(x, ...)

rmd_node_length(x, ...)

rmd_node_content(x, ...)

rmd_node_attr(x, attr, ...)

rmd_node_engine(x, ...)

rmd_node_options(x, ...)

rmd_node_code(x, ...)
}
\arguments{
\item{x}{An rmd object, e.g. \code{rmd_ast} or \code{rmd_tibble}.}

\item{...}{Unused, for extensibility.}

\item{attr}{Attribute name to extract.}
}
\value{
\itemize{
\item \code{rmd_node_label()} - returns a character vector of node labels,
nodes without labels return \code{NA}.
\item \code{rmd_node_type()} - returns a character vector of node types.
\item \code{rmd_node_length()} - returns an integer vector of node lengths (i.e. lines of code, lines of text, etc.),
nodes without a length return \code{NA}.
\item \code{rmd_node_content()} - returns a character vector of node textual content, nodes without content return \code{NA}.
\item \code{rmd_node_attr()} - returns a list of node attribute values.
\item \code{rmd_node_engine()} - returns a character vector of chunk engines,
\code{NA} for all other node types.
\item \code{rmd_node_options()} - returns a list of chunk node options (named list), \code{MULL} for all other node types.
\item \code{rmd_node_code()} - returns a list of chunk node code (character vector),
\code{NULL} for all other node types.
}
}
\description{
Functions for extracting information for Rmd nodes.
}
\examples{

rmd = parse_rmd(system.file("hw01.Rmd", package="parsermd"))

rmd_node_label(rmd)
rmd_node_type(rmd)
rmd_node_content(rmd)
rmd_node_attr(rmd, "level")
rmd_node_engine(rmd)
rmd_node_options(rmd)
rmd_node_code(rmd)

}
