% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff_blocks.R
\name{pd_get_iff_associated_name_id}
\alias{pd_get_iff_associated_name_id}
\title{Find the name that should be associated with an \code{if(FALSE)} block.}
\usage{
pd_get_iff_associated_name_id(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\description{
For \code{\link[=iff-blocks]{if(FALSE)}} documentation blocks, such as
\code{@testing} and \code{@example} blocks, a user may supply an
information string which gives the name information for tests and
examples.  for example, in \code{if(FALSE)\{#@test my special test}
the information string is "my special test".

The more common case is when there is no information string.
In these cases the name is inferred by the previous assignment or
declaration.

The \code{id} argument should identify one and only one
\code{\link[=iff-blocks]{if(FALSE)}} block, but as this is an internal
function, argument checks are not performed.
}
\details{
IFF blocks can be placed
sequentially and \code{pd_get_iff_associated_name_id} will
navigate back until it finds a non-IFF block to use for the name.
This way users can place multiple tests and examples after a
declaration.

If the previous expression is an assignment, the assignee variable of
the assignment is chosen as the name.
An attribute 'type' is also set on the return value.
For function assignments \code{type="function_assignment"},
for all other assignments \code{type="assignment"}.

The names for \code{link{setClass}} calls will also be inferred.
The name of the class is taken as the name, but the
return value also has the attribute of
\code{type="setClass"}.
Note that it is common to assign the result of
\code{\link{setClass}} to a variable, which may or
may not match the class name.  In those cases the
assignment operation takes priority and would have
\code{type="assignment"}.

The names for \code{\link{setMethod}} will assume
the S3 convention of \code{<method>.<class>}.
In the case the the signature is more than just the class,
the signature will be collapsed, separated by commas.
the type attribute will be set to \code{"setMethod"}.

\code{\link{setGeneric}} can also be used with the name
of the generic function the inferred name and
\code{type="setGeneric"}.
\code{\link{setAs}} infers coerce methods.
\code{type="setAs"}.
}
