% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_rbf.R
\name{svm_rbf}
\alias{svm_rbf}
\alias{update.svm_rbf}
\title{General interface for radial basis function support vector machines}
\usage{
svm_rbf(mode = "unknown", cost = NULL, rbf_sigma = NULL,
  margin = NULL)

\method{update}{svm_rbf}(object, cost = NULL, rbf_sigma = NULL,
  margin = NULL, fresh = FALSE, ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{rbf_sigma}{A positive number for radial basis function.}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}

\item{object}{A radial basis function SVM model specification.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{svm_rbf()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{cost}: The cost of predicting a sample within or on the
wrong side of the margin.
\item \code{rbf_sigma}: The precision parameter for the radial basis
function.
\item \code{margin}: The epsilon in the SVM insensitive loss function
(regression only)
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"kernlab"} (the default)
}
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call. For this type of
model, the template of the fit calls are::

\pkg{kernlab} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::svm_rbf(mode = "classification"), "kernlab")}

\pkg{kernlab} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::svm_rbf(mode = "regression"), "kernlab")}
}

\examples{
svm_rbf(mode = "classification", rbf_sigma = 0.2)
# Parameters can be represented by a placeholder:
svm_rbf(mode = "regression", cost = varying())
model <- svm_rbf(cost = 10, rbf_sigma = 0.1)
model
update(model, cost = 1)
update(model, cost = 1, fresh = TRUE)
}
\seealso{
\code{\link[=varying]{varying()}}, \code{\link[=fit]{fit()}}
}
