% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_data.R
\name{.convert_form_to_xy_fit}
\alias{.convert_form_to_xy_fit}
\alias{.convert_form_to_xy_new}
\alias{.convert_xy_to_form_fit}
\alias{.convert_xy_to_form_new}
\title{Helper functions to convert between formula and matrix interface}
\usage{
.convert_form_to_xy_fit(
  formula,
  data,
  ...,
  na.action = na.omit,
  indicators = "traditional",
  composition = "data.frame",
  remove_intercept = TRUE
)

.convert_form_to_xy_new(
  object,
  new_data,
  na.action = na.pass,
  composition = "data.frame"
)

.convert_xy_to_form_fit(
  x,
  y,
  weights = NULL,
  y_name = "..y",
  remove_intercept = TRUE
)

.convert_xy_to_form_new(object, new_data)
}
\arguments{
\item{formula}{An object of class \code{formula} (or one that can
be coerced to that class): a symbolic description of the model
to be fitted.}

\item{data}{A data frame containing all relevant variables (e.g. outcome(s),
predictors, case weights, etc).}

\item{...}{Additional arguments passed to \code{\link[stats:model.frame]{stats::model.frame()}} and
specification of \code{offset} and \code{contrasts}.}

\item{na.action}{A function which indicates what should happen when the data
contain NAs.}

\item{indicators}{A string describing whether and how to create
indicator/dummy variables from factor predictors. Possible options are
\code{"none"}, \code{"traditional"}, and \code{"one_hot"}.}

\item{composition}{A string describing whether the resulting \code{x} and \code{y}
should be returned as a \code{"matrix"} or a \code{"data.frame"}.}

\item{remove_intercept}{A logical indicating whether to remove the intercept
column after \code{model.matrix()} is finished.}

\item{object}{An object of class \code{model_fit}.}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{x}{A matrix, sparse matrix, or data frame of predictors. Only some
models have support for sparse matrix input. See \code{parsnip::get_encoding()}
for details. \code{x} should have column names.}

\item{y}{A vector, matrix or data frame of outcome data.}

\item{weights}{A numeric vector containing the weights.}

\item{y_name}{A string specifying the name of the outcome.}
}
\description{
Functions to take a formula interface and get the resulting
objects (y, x, weights, etc) back or the other way around. The functions are
intended for developer use. For the most part, this emulates the internals
of \code{lm()} (and also see the notes at
https://developer.r-project.org/model-fitting-functions.html).

\code{.convert_form_to_xy_fit()} and \code{.convert_xy_to_form_fit()} are for when the
data are created for modeling.
\code{.convert_form_to_xy_fit()} saves both the data objects as well as the objects
needed when new data are predicted (e.g. \code{terms}, etc.).

\code{.convert_form_to_xy_new()} and \code{.convert_xy_to_form_new()} are used when new
samples are being predicted and only require the predictors to be available.
}
\keyword{internal}
