% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree.R
\name{bag_tree}
\alias{bag_tree}
\title{Ensembles of decision trees}
\usage{
bag_tree(
  mode = "unknown",
  cost_complexity = 0,
  tree_depth = NULL,
  min_n = 2,
  class_cost = NULL,
  engine = "rpart"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{cost_complexity}{A positive number for the the cost/complexity
parameter (a.k.a. \code{Cp}) used by CART models (specific engines only).}

\item{tree_depth}{An integer for maximum depth of the tree.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{class_cost}{A non-negative scalar for a class cost (where a cost of 1
means no extra cost). This is useful for when the first level of the outcome
factor is the minority class. If this is not the case, values between zero
and one can be used to bias to the second level of the factor.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{bag_tree()} defines an ensemble of decision trees. This function can fit
classification, regression, and censored regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("bag_tree")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("bag_tree")}
}
