% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_keras.R
\name{details_linear_reg_keras}
\alias{details_linear_reg_keras}
\title{Linear regression via keras/tensorflow}
\description{
This model uses regularized least squares to fit models with numeric outcomes.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has one tuning parameter:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
}

For \code{penalty}, the amount of regularization is \emph{only} L2 penalty (i.e.,
ridge or weight decay).
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{linear_reg(penalty = double(1)) \%>\% 
  set_engine("keras") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = double(1)
## 
## Computational engine: keras 
## 
## Model fit template:
## parsnip::keras_mlp(x = missing_arg(), y = missing_arg(), penalty = double(1), 
##     hidden_units = 1, act = "linear")
}\if{html}{\out{</div>}}

\code{\link[=keras_mlp]{keras_mlp()}} is a parsnip wrapper around keras code for
neural networks. This model fits a linear regression as a network with a
single hidden unit.
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#linear-reg-keras}{examples}
for \code{linear_reg()} with the \code{"keras"} engine.
}

\subsection{References}{
\itemize{
\item Hoerl, A., & Kennard, R. (2000). \emph{Ridge Regression: Biased Estimation
for Nonorthogonal Problems}. Technometrics, 42(1), 80-86.
}
}
}
\keyword{internal}
