% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.model_fit}
\alias{autoplot.model_fit}
\alias{autoplot.glmnet}
\title{Create a ggplot for a model object}
\usage{
\method{autoplot}{model_fit}(object, ...)

\method{autoplot}{glmnet}(object, ..., min_penalty = 0, best_penalty = NULL, top_n = 3L)
}
\arguments{
\item{object}{A model fit object.}

\item{...}{For \code{\link[=autoplot.glmnet]{autoplot.glmnet()}}, options to pass to
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}}. Otherwise, this argument is ignored.}

\item{min_penalty}{A single, non-negative number for the smallest penalty
value that should be shown in the plot. If left \code{NULL}, the whole data
range is used.}

\item{best_penalty}{A single, non-negative number that will show a vertical
line marker. If left \code{NULL}, no line is shown. When this argument is used,
the \pkg{ggrepl} package is required.}

\item{top_n}{A non-negative integer for how many model predictors to label.
The top predictors are ranked by their absolute coefficient value. For
multinomial or multivariate models, the \code{top_n} terms are selected within
class or response, respectively.}
}
\value{
A ggplot object with penalty on the x-axis and coefficients on the
y-axis. For multinomial or multivariate models, the plot is faceted.
}
\description{
This method provides a good visualization method for model results.
Currently, only methods for glmnet models are implemented.
}
\details{
The \pkg{glmnet} package will need to be attached or loaded for
its \code{autoplot()} method to work correctly.
}
