% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_flexible_earth.R
\name{details_discrim_flexible_earth}
\alias{details_discrim_flexible_earth}
\title{Flexible discriminant analysis via earth}
\description{
\code{\link[mda:fda]{mda::fda()}} (in conjunction with \code{\link[earth:earth]{earth::earth()}} can fit a nonlinear
discriminant analysis model that uses nonlinear features created using
multivariate adaptive regression splines (MARS). This function can fit
classification models.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 3 tuning parameter:
\itemize{
\item \code{num_terms}: # Model Terms (type: integer, default: (see below))
\item \code{prod_degree}: Degree of Interaction (type: integer, default: 1L)
\item \code{prune_method}: Pruning Method (type: character, default: ‘backward’)
}

The default value of \code{num_terms} depends on the number of columns (\code{p}):
\code{min(200, max(20, 2 * p)) + 1}. Note that \code{num_terms = 1} is an
intercept-only model.
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

discrim_flexible(
  num_terms = integer(0),
  prod_degree = integer(0),
  prune_method = character(0)
) |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Flexible Discriminant Model Specification (classification)
## 
## Main Arguments:
##   num_terms = integer(0)
##   prod_degree = integer(0)
##   prune_method = character(0)
## 
## Computational engine: earth 
## 
## Model fit template:
## mda::fda(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     nprune = integer(0), degree = integer(0), pmethod = character(0), 
##     method = earth::earth)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{References}{
\itemize{
\item Hastie, Tibshirani & Buja (1994) Flexible Discriminant Analysis by
Optimal Scoring, \emph{Journal of the American Statistical Association},
89:428, 1255-1270
\item Friedman (1991). Multivariate Adaptive Regression Splines. \emph{The Annals
of Statistics}, 19(1), 1-67.
}
}
}
\keyword{internal}
