% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{test_permutation}
\alias{test_permutation}
\title{Permute partitions}
\usage{
test_permutation(.data, information = seq(0.1, 0.6, by = 0.1),
  partitioner = part_icc(), ..., nperm = 100)
}
\arguments{
\item{.data}{a data set to partition}

\item{information}{a vector of minimum information to fit in \code{\link[=partition]{partition()}}}

\item{partitioner}{the partitioner to use. The default is \code{\link[=part_icc]{part_icc()}}.}

\item{...}{arguments passed to \code{\link[=partition]{partition()}}}

\item{nperm}{Number of permuted data sets to test. Default is 100.}
}
\value{
a tibble with summaries on observed and permuted data (the means of
the permuted summaries), as well as list-cols containing them
}
\description{
\code{test_permutation()} permutes data and partitions the results to generate a
distribution of null statistics for observed information, number of clusters,
and number of observed variables reduced to clusters. The result is a
\code{tibble} with a summary of the observed data results and the averages of the
permuted results. The partitions and and permutations are also available in
\code{list-cols}. \code{test_permutation()} tests across a range of target information
values, as specified in the \code{information} argument.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

test_permutation(df, partitioner = part_pc1(), nperm = 10)

}
