% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{gowerLegendre}
\alias{gowerLegendre}
\alias{gowerLegendre,Partition,Partition-method}
\alias{gowerLegendre,PairCoefficients,missing-method}
\title{Gower & Legendre Index}
\usage{
gowerLegendre(p, q)

\S4method{gowerLegendre}{Partition,Partition}(p, q)

\S4method{gowerLegendre}{PairCoefficients,missing}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Gower and Legendre
\deqn{
\frac{N_{11} + N_{00}}{N_{11} + \frac{1}{2}\left(N_{10} + N_{01}\right) + N_{00}}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(gowerLegendre(new("Partition", c(0, 0, 0, 1, 1)), 
                               new("Partition", c(0, 0, 1, 1, 1))), 0.75))

}
\references{
\insertRef{Gower1986}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
