% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/passt.R
\name{run_exp}
\alias{run_exp}
\title{Run simulations and analyze data}
\usage{
run_exp(frequency, duration, lrate_onset, lrate_drop_time, lrate_drop_perc,
  patterns = diag(length(duration)), number_of_participants = 100,
  cor_noise_sd = 0)
}
\arguments{
\item{frequency}{presentation frequency for each pattern in the
matrix}

\item{duration}{presentation duration for each pattern in the
matrix}

\item{lrate_onset}{learning rate at the onset of a stimulus}

\item{lrate_drop_time}{point at which the learning rate drops, must
be lower than duration}

\item{lrate_drop_perc}{how much the learning rate drops at
lrate_drop_time}

\item{patterns}{matrix with input patterns, one row is one pattern}

\item{number_of_participants}{corresponds with number of
simulations run}

\item{cor_noise_sd}{the amount of noise added to the final
activations of the network, set to 0 if you do not want any noise}
}
\value{
data frame with three columns: f_dv, td_dv, t_dv which are
  the correlations between the frequency/total duration/single
  duration of each pattern and the activation of the network for
  each pattern, respectively.
}
\description{
Runs several simulations and returns correlative effect sizes
between the frequency/total duration/single duration of each
pattern and the output activation of the network for each pattern,
respectively. Comparable to running an empirical experiment in
judgments of frequency and duration and analyzing the data.
}
\examples{
run_exp(10:1, 1:10, 0.05, 2, 0.2)
}
\seealso{
\code{\link{run_sim}}
}
