% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ice_mask.R
\name{get_ice_mask}
\alias{get_ice_mask}
\title{Get the ice mask for a dataset.}
\usage{
get_ice_mask(time_bp = NULL, dataset)
}
\arguments{
\item{time_bp}{time slices in years before present (negative values represent
time before present, positive values time in the future). This parameter can
be a vector of times (the slices need
to exist in the dataset), a list with a min and max element setting the
range of values, or left to NULL to retrieve all time steps.
To check which slices are available, you can use
\code{\link[=get_time_bp_steps]{get_time_bp_steps()}}.}

\item{dataset}{string defining dataset to be downloaded (a list of possible
values can be obtained with \code{\link[=list_available_datasets]{list_available_datasets()}}). This function
will not work on custom datasets.}
}
\value{
a binary \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} with the ice mask as 1s
}
\description{
Get the ice mask for a dataset, either for the whole series or for specific
time points.
}
