% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_viewr_trajectories}
\alias{plot_viewr_trajectories}
\title{Plot each trajectory within a viewr object}
\usage{
plot_viewr_trajectories(
  obj_name,
  plot_axes = c("length", "width"),
  multi_plot = FALSE
)
}
\arguments{
\item{obj_name}{A viewr object (a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) that has been passed
through \code{separate_trajectories()} or \code{get_full_trajectories()}.}

\item{plot_axes}{Which position axes should be plotted? A character vector
including exactly two of the following choices must be supplied:
\code{length}, \code{width}, \code{height}. Default is c("length",
"width").}

\item{multi_plot}{Should separate plots (one per trajectory) be created or
should one multi-plot grid be generated. Defaults to FALSE, which produces
separate plots.}
}
\value{
A (base-R) series of plots or single plot (if \code{multi_plot =
  TRUE}) that depict each trajectory along the chosen axes.
}
\description{
Plot each trajectory within a viewr object
}
\examples{
library(pathviewr)

## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

motive_full <-
  motive_data \%>\%
  clean_viewr(desired_percent = 50,
              max_frame_gap = "autodetect",
              span = 0.95)

plot_viewr_trajectories(motive_full, multi_plot = FALSE)
plot_viewr_trajectories(motive_full, multi_plot = TRUE)
}
\seealso{
Other plotting functions: 
\code{\link{plot_by_subject}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{plotting functions}
