% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segplot.R
\name{segplot}
\alias{segplot}
\title{Plot the segment-analysis model}
\usage{
segplot(segdata, labels = TRUE, lab.cex = 0.9, out.lwd = 1, out.lty = 1,
  out.lcol = "black", tick.loc = c(-1, -0.5, 0.5, 1), margins = c(1, 1, 2,
  2), square = TRUE, ...)
}
\arguments{
\item{segdata}{(required) a data frame, possibly a result from the \code{colspace} 
or \code{segspace} function, containing values for 'LM' and 'MS' 
as columns (labeled as such).}

\item{labels}{plot category labels inside? Defaults to \code{TRUE}.}

\item{lab.cex}{character expansion factor for category labels when \code{labels = TRUE}).}

\item{out.lwd, out.lcol, out.lty}{graphical parameters for plot outline.}

\item{tick.loc}{a numeric vector specifying the location of tick marks on x & y axes. (defaults to c(-1, -0.5, 0.5, 1))}

\item{margins}{margins for the plot. (defaults to c(1, 1, 2, 2))}

\item{square}{square plotting area? (defaults to \code{TRUE})}

\item{...}{additional graphical options. See \code{\link{par}}.}
}
\description{
Produces a plot based on Endler's (1990) segment analysis.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'segment')
seg.flowers <- colspace(vis.flowers, space = 'segment')
plot(seg.flowers)
}

}
\references{
Endler, J. A. (1990) On the measurement and classification of 
color in studies of animal color patterns. Biological Journal of the Linnean 
Society, 41, 315-352.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
